package cn.com.duiba.application.boot.stream.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.messaging.MessageHeaders;

@ConfigurationProperties("spring.cloud.stream.integration")
public class SpringIntegrationProperties {

    /**
     * Message header names that will NOT be copied from the inbound message.
     */
    private String[] messageHandlerNotPropagatedHeaders = new String[] {
            MessageHeaders.CONTENT_TYPE };

    public String[] getMessageHandlerNotPropagatedHeaders() {
        return this.messageHandlerNotPropagatedHeaders;
    }

    public void setMessageHandlerNotPropagatedHeaders(
            String[] messageHandlerNotPropagatedHeaders) {
        this.messageHandlerNotPropagatedHeaders = messageHandlerNotPropagatedHeaders;
    }

}