/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.support;

import cn.com.duiba.application.boot.stream.binding.Binding;
import cn.com.duiba.application.boot.stream.binding.BindingService;
import cn.com.duiba.application.boot.stream.channel.ChannelKey;
import cn.com.duiba.application.boot.stream.channel.ChannelType;
import cn.com.duiba.application.boot.stream.config.BindingProperties;
import cn.com.duiba.application.boot.stream.config.BindingServiceProperties;
import cn.com.duiba.application.boot.stream.support.StreamMesseage;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StreamTemplate {
    private static final Logger log = LoggerFactory.getLogger(StreamTemplate.class);
    @Resource
    private CompositeMessageConverter compositeMessageConverter;
    @Resource
    private BindingService bindingService;
    @Resource
    private BindingServiceProperties bindingServiceProperties;

    public void send(String bindingName, Object event) {
        LinkedHashMap headers = Maps.newLinkedHashMap();
        if (event instanceof StreamMesseage) {
            String topic = ((StreamMesseage)event).topic();
            Assert.isTrue((!StringUtils.isEmpty((Object)topic) ? 1 : 0) != 0, (String)"StreamMesseage \u7684 topic\u4e0d\u80fd\u4e3a\u7a7a");
            headers.put("TOPIC", topic);
        } else {
            BindingProperties bindingProperties = this.bindingServiceProperties.getBindings().get(bindingName);
            Assert.notNull((Object)bindingProperties, (String)("\u672a\u914d\u7f6e[" + bindingName + "]\u5bf9\u5e94\u7684\u901a\u9053"));
            String defaultTopic = bindingProperties.getProducer().getDefaultTopic();
            Assert.isTrue((!StringUtils.isEmpty((Object)defaultTopic) ? 1 : 0) != 0, (String)"\u672a\u80fd\u89e3\u6790\u51fa\u6d88\u606f\u4e2d\u7684topic,\u8bf7\u786e\u4fdd\u4e8b\u4ef6\u5bf9\u8c61\u5b9e\u73b0StreamMesseage\u63a5\u53e3\u6216\u8005\u7ed9binding\u8bbe\u7f6e\u9ed8\u8ba4topic");
            headers.put("TOPIC", defaultTopic);
        }
        Message message = this.compositeMessageConverter.toMessage(event, new MessageHeaders((Map)headers));
        if (Objects.isNull(message)) {
            log.warn("Stream\u4e8b\u4ef6[" + event.getClass().getName() + "]\u672a\u80fd\u6b63\u5e38\u53d1\u5e03,\u8bf7\u63d0\u4f9b\u5bf9\u5e94\u7684MessageConverter\u8f6c\u5316\u5668");
            return;
        }
        ChannelKey key = new ChannelKey(bindingName, ChannelType.OUTPUT);
        Binding binding = this.bindingService.getBinding(key);
        AbstractMessageChannel producerMessageChannel = binding.getMessageChannel();
        producerMessageChannel.send(message);
    }
}

