package cn.com.duiba.application.boot.stream.channel;

import cn.com.duiba.application.boot.stream.config.BindingProperties;
import cn.com.duiba.application.boot.stream.config.BindingServiceProperties;
import cn.com.duiba.application.boot.stream.config.ConsumerProperties;
import cn.com.duiba.application.boot.stream.config.ProducerProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

import java.util.Map;

public class ChannelBeanFactoryPostProcessor implements BeanDefinitionRegistryPostProcessor, EnvironmentAware {

    private BindingServiceProperties bindingServiceProperties;

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        Map<String, BindingProperties> bindingPropertiesMap =  bindingServiceProperties.getBindings();
        for(String bindingName:bindingPropertiesMap.keySet()){

            BindingProperties bindingProperties = bindingPropertiesMap.get(bindingName);
            ProducerProperties producerProperties = bindingProperties.getProducer();
            if(producerProperties.getEnable()){
                ChannelKey channelKey = new ChannelKey();
                channelKey.setBindingName(bindingName);
                channelKey.setChannelType(ChannelType.OUTPUT);
                registerChannelBeanDefinition(channelKey,registry);
            }
            ConsumerProperties consumerProperties = bindingProperties.getConsumer();
            if(consumerProperties.getEnable()){
                ChannelKey channelKey = new ChannelKey();
                channelKey.setBindingName(bindingName);
                channelKey.setChannelType(ChannelType.INPUT);
                registerChannelBeanDefinition(channelKey,registry);
            }
        }
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        //nothing
    }

    private void registerChannelBeanDefinition(ChannelKey channelKey,BeanDefinitionRegistry registry){
        String beanName = ChannelFactoryBean.getBeanNameByBindingName(channelKey);

        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ChannelFactoryBean.class);
        builder.addPropertyValue("channelKey", channelKey);
        builder.addPropertyReference("channelInterceptorBox", "channelInterceptorBox");
        registry.registerBeanDefinition(beanName,builder.getBeanDefinition());
    }

    @Override
    public void setEnvironment(Environment environment) {
        bindingServiceProperties = Binder.get(environment).bind(BindingServiceProperties.STREAM_PREFIX, BindingServiceProperties.class).orElseCreate(BindingServiceProperties.class);
    }
}
