package cn.com.duiba.application.boot.stream.channel;

import cn.com.duiba.application.boot.stream.support.TopicOperater;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.AbstractMessageChannel;

import java.util.Objects;

@Slf4j
public class ProducerMessageChannel extends AbstractMessageChannel {

    private MessageHandler messageHandler;

    @Override
    protected boolean sendInternal(Message<?> message, long timeout) {
        try{
            if(Objects.isNull(messageHandler)){
                log.warn("未注入messageHandler,无法发送消息");
                throw new RuntimeException("未注入messageHandler,无法发送消息");
            }
            String topic = TopicOperater.findTopic(message);
            if(StringUtils.isBlank(topic)){
                throw new RuntimeException("消息头缺乏Topic");
            }
            messageHandler.handleMessage(message);
            return true;
        }catch (Exception e){
            log.error("stream消息发送失败",e);
            return false;
        }
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

}
