package cn.com.duiba.application.boot.stream.configuration;

import cn.com.duiba.application.boot.stream.annotation.StreamMessageConverter;
import cn.com.duiba.application.boot.stream.converter.CompositeMessageConverterFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.support.converter.ConfigurableCompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;

import java.util.List;

@Configuration
@Role(BeanDefinition.ROLE_INFRASTRUCTURE)
public class ContentTypeConfiguration {

    @Bean
    public CompositeMessageConverterFactory compositeMessageConverterFactory(
            ObjectProvider<ObjectMapper> objectMapperObjectProvider,
            @StreamMessageConverter List<MessageConverter> customMessageConverters) {
        return new CompositeMessageConverterFactory(customMessageConverters, objectMapperObjectProvider.getIfAvailable(ObjectMapper::new));
    }

    @Bean(name = IntegrationContextUtils.ARGUMENT_RESOLVER_MESSAGE_CONVERTER_BEAN_NAME)
    public ConfigurableCompositeMessageConverter configurableCompositeMessageConverter(
            CompositeMessageConverterFactory factory) {

        return new ConfigurableCompositeMessageConverter(
                factory.getMessageConverterForAllRegistered().getConverters());
    }

}
