package cn.com.duiba.application.boot.stream.binding;

import cn.com.duiba.application.boot.stream.binder.BinderMessageHandler;
import cn.com.duiba.application.boot.stream.channel.ProducerMessageChannel;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ProducerBinding extends AbstructBinding {

    @Override
    public void doBinding() {
        try{
            ProducerMessageChannel producerMessageChannel = (ProducerMessageChannel)getMessageChannel();
            BinderMessageHandler messageHandler = (BinderMessageHandler)getMessageHandler();
            producerMessageChannel.setMessageHandler(messageHandler);//构建关系
            messageHandler.start();
        }catch (Exception e){
            log.error("发布器初始化失败",e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try{
            BinderMessageHandler messageHandler = (BinderMessageHandler)getMessageHandler();
            messageHandler.stop();
        }catch (Exception e){
            log.error("发布器关闭失败",e);
            throw new RuntimeException(e);
        }

    }

}
