package cn.com.duiba.application.boot.stream.binding;

import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

/**
 * @author Marius Bogoevici
 * @author Gary Russell
 * @since 1.2
 */
public class StreamListenerMessageHandler extends AbstractReplyProducingMessageHandler {

    private final InvocableHandlerMethod invocableHandlerMethod;

    private final boolean copyHeaders;

    StreamListenerMessageHandler(InvocableHandlerMethod invocableHandlerMethod,
                                 boolean copyHeaders, String[] notPropagatedHeaders) {
        super();
        this.invocableHandlerMethod = invocableHandlerMethod;
        this.copyHeaders = copyHeaders;
        this.setNotPropagatedHeaders(notPropagatedHeaders);
    }

    @Override
    protected boolean shouldCopyRequestHeaders() {
        return this.copyHeaders;
    }

    public boolean isVoid() {
        return this.invocableHandlerMethod.isVoid();
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        try {
            return this.invocableHandlerMethod.invoke(requestMessage);
        }
        catch (Exception e) {
            if (e instanceof MessagingException) {
                throw (MessagingException) e;
            }
            else {
                throw new MessagingException(requestMessage,
                        "Exception thrown while invoking "
                                + this.invocableHandlerMethod.getShortLogMessage(),
                        e);
            }
        }
    }

}