package cn.com.duiba.application.boot.stream.binding;

import cn.com.duiba.application.boot.stream.annotation.StreamListenerScan;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

import java.util.Arrays;
import java.util.Set;

public class StreamListenerScanRegistrar implements ImportBeanDefinitionRegistrar {

    private static Set<String> scanPackages = Sets.newHashSet();

    @Override
    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attrs = AnnotatedElementUtils.getMergedAnnotationAttributes(ClassUtils.resolveClassName(metadata.getClassName(), null), StreamListenerScan.class);
        Assert.notNull(attrs,"未能提取EnableBinding中的Binding信息");
        StreamListenerScan scan = AnnotationUtils.synthesizeAnnotation(attrs,StreamListenerScan.class, ClassUtils.resolveClassName(metadata.getClassName(), null));
        scanPackages.addAll(Arrays.asList(scan.packages()));
    }

    static Set<String> getScanPackages() {
        return scanPackages;
    }

}
