package cn.com.duiba.application.boot.stream.configuration;

import cn.com.duiba.application.boot.stream.annotation.StreamChannelInterceptor;
import cn.com.duiba.application.boot.stream.binding.BindingService;
import cn.com.duiba.application.boot.stream.binding.StreamListenerAnnotationBeanPostProcessor;
import cn.com.duiba.application.boot.stream.channel.ChannelBeanFactoryPostProcessor;
import cn.com.duiba.application.boot.stream.channel.ChannelInterceptorBox;
import cn.com.duiba.application.boot.stream.config.BindingServiceProperties;
import cn.com.duiba.application.boot.stream.config.SpringIntegrationProperties;
import cn.com.duiba.application.boot.stream.converter.CompositeMessageConverterFactory;
import cn.com.duiba.application.boot.stream.resolver.SmartMessageMethodArgumentResolver;
import cn.com.duiba.application.boot.stream.resolver.SmartPayloadArgumentResolver;
import cn.com.duiba.application.boot.stream.support.StreamTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.validation.Validator;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@Slf4j
@Configuration
@Import({
        BinderTypeRegistry.class,
        ChannelBeanFactoryPostProcessor.class
})
@EnableConfigurationProperties({
        BindingServiceProperties.class,
        SpringIntegrationProperties.class
})
@EnableIntegration
public class StreamBinderConfiguration {

    @Bean
    public BindingService bindingService(){
        return new BindingService();
    }

    @Bean
    public ChannelInterceptorBox channelInterceptorBox(@Autowired(required = false) List<ChannelInterceptor> channelInterceptors){

        ChannelInterceptorBox box = new ChannelInterceptorBox();
        if(Objects.isNull(channelInterceptors)){
            return box;
        }
        for(ChannelInterceptor interceptor:channelInterceptors){
            StreamChannelInterceptor streamChannelInterceptor = AnnotationUtils.findAnnotation(interceptor.getClass(), StreamChannelInterceptor.class);
            if(Objects.nonNull(streamChannelInterceptor)){
                box.addChannelInterceptor(interceptor);
            }
        }
        return box;
    }


    @Bean(IntegrationContextUtils.MESSAGE_HANDLER_FACTORY_BEAN_NAME)
    public static MessageHandlerMethodFactory messageHandlerMethodFactory(
            CompositeMessageConverterFactory compositeMessageConverterFactory,
            @Nullable Validator validator, ConfigurableListableBeanFactory clbf) {

        DefaultMessageHandlerMethodFactory messageHandlerMethodFactory = new DefaultMessageHandlerMethodFactory();
        messageHandlerMethodFactory.setMessageConverter(
                compositeMessageConverterFactory.getMessageConverterForAllRegistered());

        List<HandlerMethodArgumentResolver> resolvers = new LinkedList<>();
        resolvers.add(new SmartPayloadArgumentResolver(
                compositeMessageConverterFactory.getMessageConverterForAllRegistered(),
                validator));
        resolvers.add(new SmartMessageMethodArgumentResolver(
                compositeMessageConverterFactory.getMessageConverterForAllRegistered()));
        resolvers.add(new HeaderMethodArgumentResolver(null, clbf));
        resolvers.add(new HeadersMethodArgumentResolver());

        messageHandlerMethodFactory.setArgumentResolvers(resolvers);
        messageHandlerMethodFactory.setValidator(validator);
        return messageHandlerMethodFactory;
    }

    /**
     * 将带有监听器的方法注册到监听通道上
     */
    @Bean
    public static StreamListenerAnnotationBeanPostProcessor streamListenerAnnotationBeanPostProcessor(){
        return new StreamListenerAnnotationBeanPostProcessor();
    }

    @Bean
    public StreamTemplate streamTemplate(){
        return new StreamTemplate();
    }

}
