/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.ui;

import cn.com.duiba.application.boot.ui.UiBootProperties;
import cn.com.duiba.application.boot.ui.mume.FileMumeLoader;
import cn.com.duiba.application.boot.ui.mume.MumeLoader;
import cn.com.duiba.application.boot.ui.resource.UiBootDataController;
import cn.com.duiba.application.boot.ui.resource.UiBootResourceManager;
import cn.com.duiba.application.boot.ui.resource.UiBootRootFilter;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@RestController
@Configuration
@EnableConfigurationProperties(value={UiBootProperties.class})
public class UiBootConfiguration
implements WebMvcConfigurer {
    @Resource
    private UiBootProperties uiBootProperties;

    @Bean
    public UiBootRootFilter ssoUiRootFilter() {
        return new UiBootRootFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public MumeLoader mumeLoader() {
        return new FileMumeLoader();
    }

    @RequestMapping(value={"/ui", "${application.boot.ui.root-path:'/ui'}/", "${application.boot.ui.root-path:'/ui'}"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:" + this.uiBootProperties.getRootPath() + "/uiboot/index.html");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/ui/**"}).addResourceLocations(new String[]{"classpath:/ui/"});
    }

    @Bean
    public UiBootResourceManager uiBootResourceManager() {
        return new UiBootResourceManager();
    }

    @Bean
    public UiBootDataController uiBootDataController() {
        return new UiBootDataController();
    }
}

