/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.ui.mume;

import cn.com.duiba.application.boot.ui.UiBootProperties;
import cn.com.duiba.application.boot.ui.mume.MumeLoader;
import cn.com.duiba.application.boot.ui.mume.UIBootMume;
import com.alibaba.fastjson.JSONArray;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;

public class FileMumeLoader
implements MumeLoader {
    private volatile List<UIBootMume> mumes = Collections.emptyList();
    @Resource
    private UiBootProperties uiBootProperties;
    @Resource
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() throws IOException {
        org.springframework.core.io.Resource resource = this.applicationContext.getResource(this.uiBootProperties.getMumeResource());
        if (!resource.exists()) {
            String message = "\u8def\u5f84\uff1a" + this.uiBootProperties.getMumeResource() + "\u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
            throw new IOException(message);
        }
        CharSource charSource = Resources.asCharSource((URL)resource.getURL(), (Charset)StandardCharsets.UTF_8);
        String context = charSource.read();
        this.mumes = JSONArray.parseArray((String)context, UIBootMume.class);
    }

    @Override
    public List<UIBootMume> loadUIMume() {
        return this.mumes;
    }

    @Override
    public Long mumeVersion() {
        return this.uiBootProperties.getMumeVersion();
    }
}

