package cn.com.duiba.bigdata.api.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageResultDto<T extends Serializable> implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 7622601582262632184L;

    /**
     *  当前页
     */
    private int               currentPage;

    /** 总数. */
    private long              totalCount;

    /** 总页数. */
    private int               totalPage;

    /** The data. */
    private List<T> list;

    /**
     * sum
     */
    private Object            sum;

    /**
     *
     * Creates a new instance of PageResultDto.
     *
     */
    public PageResultDto() {
        super();
    }

    /**
     *
     * Creates a new instance of PageResultDto.
     *
     * @param totalCount 总记录数
     * @param list 数据列表
     * @param pageSize 每页记录数
     */
    public PageResultDto(long totalCount, List<T> list, int pageSize) {
        super();
        this.totalCount = totalCount;
        this.list = list;
        this.totalPage = setToalPage(pageSize);
    }

    public PageResultDto(int currentPage, long totalCount, List<T> list, int pageSize) {
        super();
        this.currentPage = currentPage;
        this.totalCount = totalCount;
        this.list = list;
        this.totalPage = setToalPage(pageSize);
    }

    public PageResultDto(long totalCount, List<T> list, Object sum, int pageSize) {
        super();
        this.totalCount = totalCount;
        this.list = list;
        this.sum = sum;
        this.totalPage = setToalPage(pageSize);
    }

    /**
     * 空的分页信息
     * @param <T>
     * @return
     */
    public static <T extends Serializable> PageResultDto<T> emptyValue(){
        PageResultDto<T> pageResultDto = new PageResultDto<>();
        pageResultDto.setTotalPage(0);
        pageResultDto.setTotalCount(0);
        pageResultDto.setList(new ArrayList<>());
        return pageResultDto;
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private int setToalPage(int pageSize) {
        if (totalCount < 0) {
            return 0;
        }

        return (int) ((totalCount % pageSize == 0) ? totalCount / pageSize : totalCount / pageSize + 1);
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    /**
     * Gets the total page.
     *
     * @return the total page
     */
    public int getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    /**
     * @return the totalCount
     */
    public long getTotalCount() {
        return totalCount;
    }

    /**
     * @param totalCount the totalCount to set
     */
    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    /**
     * @return the list
     */
    public List<T> getList() {
        return list;
    }

    /**
     * @param list the list to set
     */
    public void setList(List<T> list) {
        this.list = list;
    }


    public Object getSum() {
        return sum;
    }

    public void setSum(Object sum) {
        this.sum = sum;
    }


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
