package cn.com.duiba.bigdata.common.biz.dto;

import lombok.Data;

import java.io.Serializable;
import java.text.DecimalFormat;

/**
 * @author xugf
 * Hologres 返回结果转化的对象
 */
@Data
public class HologresResultDto implements Serializable {

    private static final long serialVersionUID = 6330017189699677782L;

    //将消耗转化成元
    public void setConsume(Long consume) {
        this.consume = consume;

        if (consume != null) {
            this.consumeYuan = Double.parseDouble(new DecimalFormat("#.00").format(consume / 100.0));
        }
    }

    //维度
    //统计时间段 格式(yyyy-MM-dd HH:mm:ss)
    private String timeSegment;

    //媒体id
    private String appId;

    //广告位id
    private String slotId;

    //活动id
    private String activityId;

    //广告id
    private String advertId;

    //素材ID
    private String materialId;

    //广告定向配置id
    private String orientationId;

    //广告主账户id
    private String accountId;

    //代理商id
    private String agentId;

    //ADX推广组id
    private String groupId;

    //ADX资源位id
    private String resourceId;

    //ADX创意id
    private String ideaId;

    //创建App的来源
    private String appSource;

    //媒体性质 1-在线KA,2-潜力KA,3-普通媒体
    private String appLevel;

    //媒体类型 1-android，2-ios，3-js
    private String appType;

    //广告位接入方式 1:sdk,2.手动投放（接入api),3.手动投放（不接入api）
    private String slotAccessType;

    //目标转化类型（广告配置的一个属性）
    private String targetEffectType;

    //1表示表单类广告
    private String formAdvert;

    //是否免费 (0:收费 1:免费)
    private String isFree;

    //ae区域  1-华东，2-华北 3-其他
    private String aeArea;

    //aeId
    private String aeId;

    //广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）
    private String advertType;

    //活动来源 (0-兑吧 1-推啊)
    private String activitySource;

    //广告位投放活动的类型（1-插件工具、2-普通活动、3-直投页、4-自定义活动）
    private String activityType;

    //活动投放模式（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）
    private String activityReleaseMode;

    //广告位上直投活动的投放方式：仅投1 优投人工2 优投算法3 纯算法4 其他0
    private String activityReleaseSubMode;

    //广告位投放内容类型 1:活动、2：直投页、3：自定义活动
    private String releaseContentType;

    //adx投放方式 0依次 1按比例 2按算法
    private String adxPutType;

    //生效的主体类型，1-杭州推啊，2-霍尔果斯推啊
    private String companyId;

    //风控类型 0：正常，1：用户作弊，2：广告位作弊
    private String riskType;

    //广告位素材id
    private String slotMaterialId;

    //广告位素材投放方式：0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级
    private String slotMaterialPutType;

    //插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0
    private String pluginPutType;

    //媒体一级行业
    private String appFirstTradeId;

    //媒体二级行业
    private String appSecondTradeId;

    //媒体流量标签
    private String appFlowTag;

    //广告行业
    private String advertTradeTagId;

    //广告资源
    private String advertResourceTagId;

    //媒体账号id
    private String developerId;

    //流量类型
    private String flowType;

    //活动投放方式-大类（1:测试 2:算法 3:灰度测试 4:手投）
    private String activityPutType;

    //sdk version 版本
    private String sdkVersion;

    //补丁版本
    private String patchVersion;

    //活动皮肤是否出激励视频 1-出 0-不出
    private Integer withEncVedio;


    //基础指标
    //广告位曝光pv
    private Long slotExposurePV;

    //广告位曝光uv
    private Long slotExposureUV;

    //广告位点击pv
    private Long slotClickPV;

    //广告位点击uv
    private Long slotClickUV;

    //广告位访问pv
    private Long slotVisitPV;

    //广告位访问uv
    private Long slotVisitUV;

    //活动线-活动请求pv
    private Long activityRequestPV;

    //活动线-活动请求uv
    private Long activityRequestUV;

    //活动线-活动参与pv
    private Long activityJoinPV;

    //活动线-活动参与uv
    private Long activityJoinUV;

    //媒体线-活动请求pv
    private Long appActivityRequestPV;

    //媒体线-活动请求uv
    private Long appActivityRequestUV;

    //媒体线-活动参与pv
    private Long appActivityJoinPV;

    //媒体线-活动参与uv
    private Long appActivityJoinUV;

    //券请求pv
    private Long couponRequestPV;

    //发券量pv
    private Long launchCouponPV;

    //风控免费券发券量pv
    private Long riskLaunchCouponPV;

    //付费券发券量pv
    private Long launchPayCouponPV;

    //券曝光pv
    private Long couponExposurePV;

    //券普通点击pv
    private Long couponClickPV;

    //券计费点击pv
    private Long couponEffectClickPV;

    //消耗（单位分）
    private Long consume;

    //消耗（单位元）
    private Double consumeYuan;

    //增值广告消耗
    private Long encourageConsume;

    //落地页曝光pv
    private Long lpExposePV;

    //落地页转化pv
    private Long lpClickPV;

    //表单类落地页转化pv
    private Long formLpClickPV;

    //表单类券点击pv
    private Long formCouponClickPV;

    //下载成功数为SDK下载补丁成功数量
    private Long downPatchSuccUv;

    //生效数为补丁成功生效的数量
    private Long downSuccEffectUv;

    //SDK版本总数为该sdk版本总用户数
    private Long sdkUv;

    //视频活动参与pv
    private Long videoActivityJoinPV;

    //视频活动参与uv
    private Long videoActivityJoinUV;

    //看视频按钮点击次数
    private Long watchVideoClickPV;

    //看视频弹窗点击关闭按钮次数
    private Long closeWindowClickPV;

    //看视频弹窗曝光次数
    private Long windowExposurePV;

    //看视频按钮点击uv
    private Long watchVideoClickUV;

    //看视频弹窗点击关闭按钮uv
    private Long closeWindowClickUV;

    //看视频弹窗曝光uv
    private Long windowExposureUV;

    //计算类指标
    //arpu值
    private Double arpu;


}
