package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf (不再继续维护)
 * druid 维度字段
 * DruidDimensionEnum 替换成 HologresDimensionEnum, druid系统即将淘汰
 */
@Deprecated
public enum DruidDimensionEnum {

    //媒体id
    APP_ID("app_id", "appId", "duiba_inner_log,duiba_access_log", "媒体id"),

    //广告位id
    SLOT_ID("slot_id", "slotId", "duiba_inner_log,duiba_access_log", "广告位id"),

    //活动id
    ACTIVITY_ID("activity_id", "activityId", "duiba_inner_log,duiba_access_log", "活动id"),

    //广告id
    ADVERT_ID("advert_id", "advertId", "duiba_inner_log", "广告id"),

    //素材ID
    MATERIAL_ID("material_id", "materialId", "duiba_inner_log", "素材ID"),

    //广告定向配置id，0为默认配置
    ORIENTATION_ID("orientation_id", "orientationId", "duiba_inner_log", "广告定向配置id，0为默认配置"),

    //广告主账户id
    ACCOUNT_ID("account_id", "accountId", "duiba_inner_log", "广告主账户id"),

    //代理商id
    AGENT_ID("agent_id", "agentId", "duiba_inner_log", "代理商id"),

    //广告资源id
    ADVERT_RESOURCE_TAG_ID("advert_resource_tag_id", "advertResourceTagId", "duiba_inner_log", "广告资源id"),

    //ADX推广组id
    GROUP_ID("group_id", "groupId", "duiba_inner_log,duiba_access_log", "ADX推广组id"),

    //ADX资源位id
    RESOURCE_ID("resource_id", "resourceId", "duiba_inner_log,duiba_access_log", "ADX资源位id"),

    //ADX创意id
    IDEA_ID("idea_id", "ideaId", "duiba_inner_log,duiba_access_log", "ADX创意id"),

    //创建App的来源 0：积分商城（兑吧） 1：广告平台（推啊）
    APP_SOURCE("app_source", "appSource", "duiba_inner_log,duiba_access_log", "创建App的来源 0：积分商城（兑吧） 1：广告平台（推啊）"),

    //媒体性质 1-在线KA,2-潜力KA,3-普通媒体
    APP_LEVEL("app_level", "appLevel", "duiba_inner_log,duiba_access_log", "媒体性质 1-在线KA,2-潜力KA,3-普通媒体"),

    //媒体类型 1-在线ka 2-普通媒体 3-rtb-adx 4-rtb-非adx
    APP_TYPE("app_type", "appType", "duiba_inner_log,duiba_access_log", "媒体类型 1-在线ka 2-普通媒体 3-rtb-adx 4-rtb-非adx "),

    //目标转化类型（广告配置的一个属性）
    TARGET_EFFECT_TYPE("target_effect_type", "targetEffectType", "duiba_inner_log", "目标转化类型（广告配置的一个属性）"),

    //1表示表单类广告
    FORM_ADVERT("form_advert", "formAdvert", "duiba_inner_log", "1表示表单类广告"),

    //是否免费 (0:收费 1:免费)
    IS_FREE("is_free", "isFree", "duiba_inner_log", "是否免费 (0:收费 1:免费)"),

    //新媒体类型appType 0-老媒体，1-新媒体测试发券，2-新媒体,非新媒体测试发券
    NEW_APP_TYPE("new_app_type", "newAppType", "duiba_inner_log", "新媒体类型appType 0-老媒体，1-新媒体测试发券，2-新媒体,非新媒体测试发券"),

    //ae区域  1-华东，2-华北 3-其他
    AE_AREA("ae_area", "aeArea", "duiba_inner_log", "ae区域  1-华东，2-华北 3-其他"),

    //aeId
    AE_ID("ae_id", "aeId", "duiba_inner_log", "aeId"),

    //广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）
    ADVERT_TYPE("advert_type", "advertType", "duiba_inner_log", "广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）"),

    //活动来源 (0-兑吧 1-推啊)
    ACTIVITY_SOURCE("activity_source", "activitySource", "duiba_inner_log,duiba_access_log", "活动来源 (0-兑吧 1-推啊)"),

    //广告位投放活动类型 1-常规活动，2-自定义活动（非深度），3-直投页，4-深度互动，5-原生互动，6-激励互动
    ACTIVITY_TYPE("activity_type", "activityType", "duiba_inner_log,duiba_access_log", "广告位投放活动的类型（1-常规活动，2-自定义活动（非深度），3-直投页，4-深度互动，5-原生互动，6-激励互动）"),

    //活动投放方式-大类（1:测试 2:算法 3:灰度测试 4:手投）
    ACTIVITY_PUT_TYPE("activity_put_type", "activityPutType", "duiba_inner_log,duiba_access_log", "活动投放方式-大类（1:测试 2:算法 3:灰度测试 4:手投）"),

    //活动投放模式（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）
    ACTIVITY_RELEASE_MODE("activity_release_mode", "activityReleaseMode", "duiba_inner_log,duiba_access_log", "活动投放模式（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）"),

    //广告位上直投活动的投放方式：仅投1 优投人工2 优投算法3 纯算法4 其他0
    ACTIVITY_RELEASE_SUB_MODE("activity_release_sub_mode", "activityReleaseSubMode", "duiba_inner_log,duiba_access_log", "广告位上直投活动的投放方式：仅投1 优投人工2 优投算法3 纯算法4 其他0"),

    //广告位投放内容类型 1:活动、2：直投页、3：自定义活动
    RELEASE_CONTENT_TYPE("release_content_type", "releaseContentType", "duiba_inner_log,duiba_access_log", "广告位投放内容类型 1:活动、2：直投页、3：自定义活动"),

    //adx投放方式 0依次 1按比例 2按算法
    ADX_PUT_TYPE("adx_put_type", "adxPutType", "duiba_inner_log,duiba_access_log", "adx投放方式 0依次 1按比例 2按算法"),

    //生效的主体类型，1-杭州推啊，2-霍尔果斯推啊
    COMPANY_ID("company_id", "companyId", "duiba_inner_log", "生效的主体类型，1-杭州推啊，2-霍尔果斯推啊"),

    //风控类型 0：正常，1：用户作弊，2：广告位作弊
    RISK_TYPE("risk_type", "riskType", "duiba_inner_log", "风控类型 0：正常，1：用户作弊，2：广告位作弊"),

    //广告位素材id
    SLOT_MATERIAL_ID("slot_material_id", "slotMaterialId", "duiba_inner_log", "广告位素材id"),

    //广告位素材投放方式：0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级
    SLOT_MATERIAL_PUT_TYPE("slot_material_put_type", "slotMaterialPutType", "duiba_inner_log", "广告位素材投放方式：0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级"),

    //插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0
    PLUGIN_PUT_TYPE("plugin_put_type", "pluginPutType", "duiba_inner_log,duiba_access_log", "插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0"),

    //媒体一级行业
    APP_FIRST_TRADE_ID("app_first_trade_id", "appFirstTradeId", "duiba_inner_log,duiba_access_log", "媒体一级行业"),

    //媒体二级行业
    APP_SECOND_TRADE_ID("app_second_trade_id", "appSecondTradeId", "duiba_inner_log,duiba_access_log", "媒体二级行业"),

    //媒体流量标签
    APP_FLOW_TAG("app_flow_tag", "appFlowTag", "duiba_inner_log,duiba_access_log", "媒体流量标签"),

    //广告行业
    ADVERT_TRADE_TAG_ID("advert_trade_tag_id", "advertTradeTagId", "duiba_inner_log", "广告行业"),

    //媒体账号id
    DEVELOPER_ID("developer_id", "developerId", "duiba_inner_log,duiba_access_log", "媒体账号id"),

    //资源位类型 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截
    DSM2_A("dsm2_a", "dsm2A", "duiba_inner_log,duiba_access_log", "资源位类型 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截"),

    //流量类型 (1:sdk 2:adx 3:其它)
    FLOW_TYPE("flow_type", "flowType", "duiba_inner_log,duiba_access_log", "流量类型 1:sdk 2:adx 3:其它"),

    //sdk版本
    SDK_VERSION("sdk_version", "sdkVersion", "duiba_inner_log", "sdk版本"),

    //补丁版本
    PATCH_VERSION("patch_version", "patchVersion", "duiba_inner_log", "补丁版本")
    ;


    //druid 中表定义的字段名称
    private String tableFieldName;

    //结果数据对应的别名
    private String resultFieldName;

    //维度适用于druid中的database表，多个database表用 ","分隔
    private String applyDatabase;

    //维度解释说明
    private String desc;

    DruidDimensionEnum(String tableFieldName, String resultFieldName, String applyDatabase, String desc) {
        this.tableFieldName = tableFieldName;
        this.resultFieldName = resultFieldName;
        this.applyDatabase = applyDatabase;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getDesc() {
        return desc;
    }

    public String getApplyDatabase() {
        return applyDatabase;
    }
}
