package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaInnerLogDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    CONSUMER_ID("consumer_id", "用户id"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("sdk_version", "sdk版本"),

    ACTIVITY_ID("sdk_report_type", "sdk上报类型 1-SDK启动上报，2-SDK崩溃上报"),

    COMPANY_ID("sdk_source", "1-创新SDK  其他-大盘SDK"),

    ADVERT_TYPE("patch_type", "补丁状态 1-补丁下载 2-补丁生效"),

    ADVERT_TRADE_TAG_ID("patch_version", "补丁版本号"),

    FORM_ADVERT("download_status", "SDK下载状态 1-SDK下载成功 2-SDK下载失败")









    ;


    //hologres 中表定义的字段名称
    private String tableFieldName;

    //字段备注
    private String desc;

    DuibaInnerLogDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
