package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf
 * hologres 计算类指标字段
 */
public enum HologresCalculateMetricEnum {

    //广告消耗/发券pv
    ARPU("CONSUME", "LAUNCH_COUPON_PV", "case when sum(consume) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(consume) as FLOAT) / sum(launchCouponPV) / 100 as numeric), 4) end as arpu")


    ;


    //指标-分子
    private String numerator;

    //指标-分母
    private String denominator;

    //指标sql代码段
    private String metricSql;

    HologresCalculateMetricEnum(String numerator, String denominator, String metricSql) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.metricSql = metricSql;
    }

    public String getNumerator() {
        return numerator;
    }

    public String getDenominator() {
        return denominator;
    }

    public String getMetricSql() {
        return metricSql;
    }}
