/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.utils.BigdataCatUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureTaskUtil {
    private static final Logger log = LoggerFactory.getLogger(FutureTaskUtil.class);

    public static <T> FutureTask<T> getFutureTask(ExecutorService executorService, Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        executorService.submit(task);
        return task;
    }

    public static <T> T getFutureTaskResult(FutureTask<T> task, long timeout, TimeUnit unit, String name) {
        try {
            if (task == null) {
                return null;
            }
            return task.get(timeout, unit);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    BigdataCatUtil.logEvent("timeout", name);
                }
            } else if (e instanceof ExecutionException) {
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    BigdataCatUtil.logEvent("executionException", name);
                }
            } else {
                log.error("getFutureTaskResult error, name = {} ", (Object)name, (Object)e);
            }
            return null;
        }
    }

    public static <T> FutureTask<T> getFutureTask(Callable<T> callable, ExecutorService submitExecutorService, ExecutorService taskExecutorService, long timeout, String name) {
        return FutureTaskUtil.getFutureTask(submitExecutorService, () -> FutureTaskUtil.getFutureTaskResult(FutureTaskUtil.getFutureTask(taskExecutorService, callable), timeout, TimeUnit.MILLISECONDS, name));
    }
}

