package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaExposureLogDetailMonthEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    CONSUMER_ID("consumer_id", "用户id"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    ACTIVITY_ID("activity_id", "活动id"),

    APP_SOURCE("app_source", "创建App的来源  0：积分商城（兑吧） 1：广告平台（推啊）"),

    DEVELOPER_ID("developer_id", "媒体账号id"),

    DSM2_A("dsm2_a", "资源位类型 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截"),

    ENC_VIDEO_MODULE_TYPE("enc_video_module_type", "激励视频埋点类型 1 弹窗曝光  2 视频按钮点击 3 视频弹窗关"),

    WITH_ENC_VEDIO("with_enc_vedio", "活动皮肤是否出激励视频 1-出 0-不出")

    ;


    //hologres 中表定义的字段名称
    private String tableFieldName;

    //字段备注
    private String desc;

    DuibaExposureLogDetailMonthEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
