package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf
 * hologres 基础指标字段
 */
public enum HologresMetricEnum {

    //广告位曝光pv
    SLOT_EXPOSURE_PV("slotExposurePV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type in (2, 151)", "广告位曝光pv"),

    //广告位曝光uv
    SLOT_EXPOSURE_UV("slotExposureUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type in (2, 151)", "广告位曝光uv"),

    //广告位点击pv
    SLOT_CLICK_PV("slotClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type in (3, 152)", "广告位点击pv"),

    //广告位点击uv
    SLOT_CLICK_UV("slotClickUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type in (3, 152)", "广告位点击uv"),

    //广告位访问pv
    SLOT_VISIT_PV("slotVisitPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "url_host = 'activity.tuia.cn' and http_method = 'GET' and tenter='SOW'", "广告位访问pv"),

    //广告位访问uv
    SLOT_VISIT_UV("slotVisitUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "url_host = 'activity.tuia.cn' and http_method = 'GET' and tenter='SOW'", "广告位访问uv"),

    //媒体线-活动请求pv
    APP_ACTIVITY_REQUEST_PV("appActivityRequestPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "url_host = 'activity.tuia.cn' and (url_path in('/activity/index','/mainmeet/index','/actcenter/index','/direct/index') or (url_path in('/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex') and dpm_b=38))", "活动请求pv"),

    //媒体线-活动请求uv
    APP_ACTIVITY_REQUEST_UV("appActivityRequestUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "url_host = 'activity.tuia.cn' and url_path in ('/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex')", "活动请求uv"),

    //媒体线-活动参与pv
    APP_ACTIVITY_JOIN_PV("appActivityJoinPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与pv"),

    //媒体线-活动参与uv
    APP_ACTIVITY_JOIN_UV("appActivityJoinUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与uv"),

    //活动线-活动请求pv
    ACTIVITY_REQUEST_PV("activityRequestPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "activity_stage = 2", "活动请求pv"),

    //活动线-活动请求uv
    ACTIVITY_REQUEST_UV("activityRequestUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "activity_stage = 2", "活动请求uv"),

    //活动线-活动参与pv
    ACTIVITY_JOIN_PV("activityJoinPV", "count(1)", "sum(count_pv)", "duiba_access_log_detail_month", "duiba_access_log_offline", "activity_stage = 3", "活动参与pv"),

    //活动线-活动参与uv
    ACTIVITY_JOIN_UV("activityJoinUV", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_access_log_detail_month", "duiba_access_log_offline", "activity_stage = 3", "活动参与uv"),

    //券请求pv
    COUPON_REQUEST_PV("couponRequestPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 23", "券请求pv"),

    //发券量pv
    LAUNCH_COUPON_PV("launchCouponPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 20", "发券量pv"),

    //风控免费券发券量pv
    RISK_LAUNCH_COUPON_PV("riskLaunchCouponPV", "count(case when risk_type != '0' then 1 else null end)", "sum(case when risk_type != '0' then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 20", "风控免费券发券量pv"),

    //付费券发券量pv
    LAUNCH_PAY_COUPON_PV("launchPayCouponPV", "count(case when is_free = '0' then 1 else null end)", "sum(case when is_free = '0' then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 20", "付费券发券量pv"),

    //免费券发券量pv
    LAUNCH_FREE_COUPON_PV("launchFreeCouponPV", "count(case when is_free = '1' then 1 else null end)", "sum(case when is_free = '1' then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 20", "免费券发券量pv"),

    //券曝光pv
    COUPON_EXPOSURE_PV("couponExposurePV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 22", "券曝光pv"),

    //券普通点击pv
    COUPON_CLICK_PV("couponClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 21", "券普通点击pv"),

    //券计费点击pv
    COUPON_EFFECT_CLICK_PV("couponEffectClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 25", "券计费点击pv"),

    //表单类券点击pv
    FORM_COUPON_CLICK_PV("formCouponClickPV", "count(case when form_advert = '1' then 1 else null end)", "sum(case when form_advert = '1' then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 25", "表单类券点击pv"),

    //消耗
    CONSUME("consume", "sum(fee)", "sum(fee)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 25", "消耗"),

    //增值广告消耗
    ENCOURAGE_CONSUME("encourageConsume", "sum(case when advert_type = '6' then fee else null end)", "sum(case when advert_type = '6' then fee else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 25", "增值广告消耗"),

    //落地页曝光pv
    LP_EXPOSE_PV("lpExposePV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 7", "落地页曝光pv"),

    //落地页转化pv
    LP_CLICK_PV("lpClickPV", "count(1)", "sum(count_pv)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 8", "落地页转化pv"),

    //表单类落地页转化pv
    FORM_LP_CLICK_PV("formLpClickPV", "count(case when form_advert = '1' then 1 else null end)", "sum(case when form_advert = '1' then count_pv else null end)", "duiba_inner_log_detail_month", "duiba_inner_log_offline", "inner_group = 1 and inner_type = 8", "表单类落地页转化pv"),



    //只提供当天的指标列表，不提供历史聚合数据
    //下载成功数为SDK下载补丁成功数量down_patch_succ_uv
    DOWN_PATCH_SUCC_UV("downPatchSuccUv", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_day", "", "inner_group = 1 and inner_type = 186 and  download_status = 1", "sdk热更新,SDK下载补丁成功数量"),

    //生效数为补丁成功生效的数量  patch_succ_effect_uv
    DOWN_SUCC_EFFECT_UV("downSuccEffectUv", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_day", "", "inner_group = 1 and inner_type = 186 and patch_type = 2", "sdk热更新,补丁成功生效的数量"),

    //SDK版本总数为该sdk版本总用户数 sdk_uv
    SDK_UV("sdkUv", "approx_count_distinct(consumer_id)", "approx_count_distinct_unnest(consumer_array)", "duiba_inner_log_detail_day", "", "inner_group = 1 and inner_type = 164 and sdk_report_type = 1", "sdk热更新,sdk版本总用户数"),

    //total_times_pv,启动次数   sum(case when sdk_report_type = 1 then count_pv else null end)--pv
    TOTAL_TIMES_PV("totalTimesPv", "count(case when sdk_report_type = 1 then 1 else null end)", "", "duiba_inner_log_detail_day", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "启动次数"),

    // total_device_uv,启动设备数  count(distinct case when sdk_report_type = 1 then device_uv else null end)--uv
    TOTAL_DEVICES_UV("totalDevicesUv", "approx_count_distinct(case when sdk_report_type = 1 then consumer_id else null end)", "", "duiba_inner_log_detail_day", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "启动设备数"),

    // crash_times_pv, 崩溃次数  sum(case when sdk_report_type = 2 then count_pv else null end)--pv
    CRASH_TIMES_PV("crashTimesPv", "count(case when sdk_report_type = 2 then 1 else null end)", "", "duiba_inner_log_detail_day", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "崩溃数"),

    //crash_device_uv 影响设备数  count(distinct case when sdk_report_type = 2 then device_uv else null end)--uv
    CRASH_DEVICES_UV("crashDevicesUv", "approx_count_distinct(case when sdk_report_type = 2 then consumer_id else null end)", "", "duiba_inner_log_detail_day", "", "inner_group = 1 and inner_type = 164 and sdk_source != 1", "崩溃设备数"),

    //视频活动参与pv
    VIDEO_ACTIVITY_JOIN_PV("videoActivityJoinPV", "count(1)",  "", "duiba_access_log_detail_month","","dpm_b=66 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')","视频活动参与pv"),

    //视频活动参与uv
    VIDEO_ACTIVITY_JOIN_UV("videoActivityJoinUV", "approx_count_distinct(consumer_id)",  "", "duiba_access_log_detail_month","","dpm_b=66 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')","视频活动参与uv"),

    //看视频按钮点击次数
    WATCH_VIDEO_CLICK_PV("watchVideoClickPV", "count(1)",  "", "duiba_access_log_detail_month","","enc_video_module_type = 2 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')","看视频按钮点击pv"),

    //看视频按钮点击uv
    WATCH_VIDEO_CLICK_UV("watchVideoClickUV", "approx_count_distinct(consumer_id)",  "", "duiba_access_log_detail_month","","enc_video_module_type = 2 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')","看视频按钮点击uv"),

    //看视频弹窗点击关闭按钮次数
    CLOSE_WINDOW_CLICK_PV("closeWindowClickPV", "count(1)",  "", "duiba_access_log_detail_month","","enc_video_module_type = 3 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')","看视频弹窗点击关闭按钮pv"),

    //看视频弹窗点击关闭按钮uv
    CLOSE_WINDOW_CLICK_UV("closeWindowClickUV", "approx_count_distinct(consumer_id)",  "", "duiba_access_log_detail_month","","enc_video_module_type = 3 and url_host = 'activity.tuia.cn' and url_path in ('/statistics/click','/tuia-activity-booter/statistics/click')","看视频弹窗点击关闭按钮uv"),

    //看视频弹窗曝光次数
    WINDOW_EXPOSURE_PV("windowExposurePV", "count(1)",  "", "duiba_exposure_log_detail_month","","enc_video_module_type = 1","看视频弹窗曝光pv"),

    //看视频弹窗曝光uv
    WINDOW_EXPOSURE_UV("windowExposureUV", "approx_count_distinct(consumer_id)",  "", "duiba_exposure_log_detail_month","","enc_video_module_type = 1","看视频弹窗曝光uv");

    //指标字段名称
    private String fieldName;

    //指标sql代码段
    private String metricSql;

    //指标sql代码段（离线数据）
    private String offlineMetricSql;

    //指标对应的 hologres 表
    private String tableName;

    //指标对应的 hologres 表（离线数据）
    private String offlineTableName;

    //指标特定的查询条件
    private String condition;

    //指标解释说明
    private String desc;

    HologresMetricEnum(String fieldName, String metricSql, String offlineMetricSql, String tableName,
                       String offlineTableName, String condition, String desc) {
        this.fieldName = fieldName;
        this.metricSql = metricSql;
        this.offlineMetricSql = offlineMetricSql;
        this.tableName = tableName;
        this.offlineTableName = offlineTableName;
        this.condition = condition;
        this.desc = desc;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getOfflineMetricSql() {
        return offlineMetricSql;
    }

    public String getTableName() {
        return tableName;
    }

    public String getOfflineTableName() {
        return offlineTableName;
    }

    public String getCondition() {
        return condition;
    }

    public String getDesc() {
        return desc;
    }}
