/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DruidUtil {
    @SafeVarargs
    public static <T> List<T> mergeList(Class<T> clazz, String dimensions, List<T> ... ObjectList) {
        if (StringUtils.isBlank((CharSequence)dimensions)) {
            return null;
        }
        String[] dimArray = StringUtils.split((String)dimensions, (String)",");
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (List<T> list : ObjectList) {
            DruidUtil.setValue(dimArray, map, list);
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (Map.Entry entry : map.entrySet()) {
            Object[] objectArray = ((List)entry.getValue()).toArray();
            resultList.add(DruidUtil.merge(clazz, objectArray));
        }
        return resultList;
    }

    public static <T> T merge(Class<T> clazz, Object ... objects) {
        JSONObject json = new JSONObject();
        for (Object object : objects) {
            DruidUtil.mergeFields(object, json);
        }
        return (T)json.toJavaObject(clazz);
    }

    private static String getKey(String[] dimArray, JSONObject jsonObject) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String dimension : dimArray) {
            String value = jsonObject.getString(dimension.trim());
            value = StringUtils.isBlank((CharSequence)value) ? "0" : value;
            stringBuilder.append(value).append("-");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static void mergeFields(Object object, JSONObject json) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)object));
        Set keySet = jsonObject.keySet();
        for (String key : keySet) {
            String value = jsonObject.getString(key);
            DruidUtil.setValue(key, value, json);
        }
    }

    private static <T> void setValue(String[] dimArray, Map<String, List<Object>> map, List<T> list) {
        for (T object : list) {
            String key = DruidUtil.getKey(dimArray, JSON.parseObject((String)JSON.toJSONString(object)));
            if (map.containsKey(key)) {
                map.get(key).add(object);
                continue;
            }
            ArrayList<T> mapValueList = new ArrayList<T>();
            mapValueList.add(object);
            map.put(key, mapValueList);
        }
    }

    private static void setValue(String key, String value, JSONObject json) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (!json.containsKey((Object)key)) {
            json.put(key, (Object)value);
        } else if (!json.getString(key).equalsIgnoreCase(value) && Double.parseDouble(value) != 0.0) {
            json.put(key, (Object)value);
        }
    }
}

