package cn.com.duiba.bigdata.common.biz.enums;

import java.util.HashMap;
import java.util.Map;

public enum DimStatisticsIndexEnum {
    INSTANCE;

    private Map<String, Integer> dimIndexMap;

    private DimStatisticsIndexEnum() {
        dimIndexMap = new HashMap<>();

        //填写维度名称和对应的顺序
        //广告
        dimIndexMap.put("advert", 1);
        //广告配置
        dimIndexMap.put("package", 2);
        //媒体
        dimIndexMap.put("app", 3);
        //广告位
        dimIndexMap.put("slot", 4);
        //广告发券次数
        dimIndexMap.put("launch_times", 5);
        //活动
        dimIndexMap.put("activity", 6);
        //素材
        dimIndexMap.put("material", 7);
        //广告类型
        dimIndexMap.put("main_type", 8);
        //流量来源
        dimIndexMap.put("flow_type", 9);
        //广告二级标签
        dimIndexMap.put("second_tag", 10);
        //广告计费方式
        dimIndexMap.put("charge_type", 11);
        //托管广告转化成本
        dimIndexMap.put("trusteeship_cost", 12);
        //渠道类型
        dimIndexMap.put("source_type", 13);
        //广告位素材
        dimIndexMap.put("slot_material", 14);
        //出价区间 1：0-5 2：5-10 3：10-15
        dimIndexMap.put("fee_level", 15);
        //算法推荐类型
        dimIndexMap.put("alg_type", 16);
        //是否是表单类广告 0:非表单 1:表单
        dimIndexMap.put("form_advert", 17);
        //adx资源位
        dimIndexMap.put("resource", 18);
        //adx创意
        dimIndexMap.put("idea", 19);
        //adx出价策略
        dimIndexMap.put("adx_strategy", 20);
        //adx出价区间
        dimIndexMap.put("adx_level", 21);
        //媒体一级行业
        dimIndexMap.put("app_first_trade", 22);
        //广告行业
        dimIndexMap.put("advert_trade", 23);
        //排序分
        dimIndexMap.put("rank_score", 24);
        //目标转化类型
        dimIndexMap.put("target_type", 25);
        //MDP托管自动人群
        dimIndexMap.put("dmp_tag", 26);
        //资源位类型
        dimIndexMap.put("resource_type", 27);
        //插件ID
        dimIndexMap.put("plugin", 28);
        //插件次序
        dimIndexMap.put("plugin_index", 29);
        //活动投放方式
        dimIndexMap.put("activity_put_type", 30);
        //广告位素材算法版本
        dimIndexMap.put("material_alg_type", 31);
        //adx出价类型
        dimIndexMap.put("adx_price_type", 32);
        //活动推荐算法版本
        dimIndexMap.put("activity_alg_type", 33);

        //推荐标题
        dimIndexMap.put("title", 34);

        //SDK实际投放类型
        dimIndexMap.put("sdk_actual_type", 35);

        //adx ctr预估区间
        dimIndexMap.put("adx_pre_interval", 36);

        //adx 过滤类型 1-对照组、不过滤 2-测试组、过滤
        dimIndexMap.put("adx_filter_type", 37);

        //返回拦截内容id
        dimIndexMap.put("inter_content_id", 38);
        //返回拦截内容类型
        dimIndexMap.put("inter_content_type", 39);
        //点击价值分层
        dimIndexMap.put("click_value_level", 40);
        //adx交易模式
        dimIndexMap.put("adx_deal_type", 41);

        //模型类型
        dimIndexMap.put("dfee_model_id", 42);

        //adx竞价过滤 0-不过滤，1-流量预过滤，2-每pv发券过滤
        dimIndexMap.put("adx_stat_filter_type", 43);

        //广告位素材标签
        dimIndexMap.put("slot_material_tag", 44);

        //活动皮肤类型
        dimIndexMap.put("skin", 45);

        //活动奖品标签
        dimIndexMap.put("prize_tag", 46);

        //媒体二级行业
        dimIndexMap.put("app_second_trade", 47);

        //百度app_id
        dimIndexMap.put("baidu_app_id", 48);

        //广告主
        dimIndexMap.put("account_id", 49);

        //ocpc拓展测试组
        dimIndexMap.put("ocpc_exp_test", 50);

        //ad_explore 探索类型
        dimIndexMap.put("ad_explore", 51);

        //实验id
        dimIndexMap.put("exp_id", 52);

        //实验组
        dimIndexMap.put("exp_group", 53);

        //创意素材
        dimIndexMap.put("idea_material", 54);

        //创意尺寸
        dimIndexMap.put("idea_size", 55);

    }

    public Integer getDimIndex(String dim) {
        return dimIndexMap.get(dim);
    }
}
