package cn.com.duiba.bigdata.common.biz.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf
 * hologres 计算类指标字段
 */
public enum HologresCalculateMetricEnum {

    //adx分成比例 1.15*adx消耗/消耗
    ADX_DIVIDE_PERCENT("ADX_CONSUME", "CONSUME", "case when sum(adxConsume) = 0 or sum(consume) = 0 then 0 else round(cast(cast(sum(adxConsume) as float) / sum(consume) as numeric), 4) end", "adxDividePercent", "adx分成比例"),

    //adx ROI 消耗/adx消耗
    ADX_ROI("CONSUME", "ADX_CONSUME", "case when sum(consume) = 0 or sum(adxConsume) = 0 then 0 else round(cast(cast(sum(consume) as float) / sum(adxConsume) as numeric), 4) end", "adxRoi", "adxROI"),

    //adx竞价返回率 真实返回数/请求数
    ADX_BID_RETURN_RATE("ADX_FINAL_BID_PV", "ADX_BID_REQUEST_PV", "case when sum(adxFinalBidPv) = 0 or sum(adxBidRequestPv) = 0 then 0 else round(cast(cast(sum(adxFinalBidPv) as float)/ sum(adxBidRequestPv) as numeric), 4) end", "adxBidReturnRate", "adx竞价返回率"),

    //adx竞价成功率 竞价成功数/竞价返回数
    ADX_BID_SUCCESS_RATE("ADX_BID_SUCCESS_PV", "ADX_BID_RETURN_PV", "case when sum(adxBidSuccessPv) = 0 or sum(adxBidReturnPv) = 0 then 0 else round(cast(cast(sum(adxBidSuccessPv) as float)/ sum(adxBidReturnPv) as numeric), 4) end", "adxBidSuccessRate", "adx竞价成功率"),

    //adx竞价成功成本 adx消耗/竞价成功数
    ADX_BID_SUCCESS_COST("ADX_CONSUME", "ADX_BID_SUCCESS_PV", "case when sum(adxConsume) = 0 or sum(adxBidSuccessPv) = 0 then 0 else round(cast(cast(sum(adxConsume) as float)/ sum(adxBidSuccessPv) as numeric), 4) end", "adxBidSuccessCost", "adx竞价成功成本"),

    //adx曝光率 adx曝光/竞价成功数
    ADX_EXPOSURE_RATE("ADX_EXPOSURE_PV", "ADX_BID_SUCCESS_PV", "case when sum(adxExposurePv) = 0 or sum(adxBidSuccessPv) = 0 then 0 else round(cast(cast(sum(adxExposurePv) as float)/ sum(adxBidSuccessPv) as numeric), 4) end", "adxExposureRate", "adx曝光率"),

    //adx曝光成本 adx消耗/adx曝光
    ADX_EXPOSURE_COST("ADX_CONSUME", "ADX_EXPOSURE_PV", "case when sum(adxConsume) = 0 or sum(adxExposurePv) = 0 then 0 else round(cast(cast(sum(adxConsume) as float)/ sum(adxExposurePv) as numeric), 4) end", "adxExposureCost", "adx曝光成本"),

    //adx点击率 adx点击/adx曝光
    ADX_CLICK_RATE("ADX_CLICK_PV", "ADX_EXPOSURE_PV", "case when sum(adxClickPv) = 0 or sum(adxExposurePv) = 0 then 0 else round(cast(cast(sum(adxClickPv) as float)/ sum(adxExposurePv) as numeric), 4) end", "adxClickRate", "adx点击率"),

    //adx点击成本 adx消耗/adx点击
    ADX_CLICK_COST("ADX_CONSUME", "ADX_CLICK_PV", "case when sum(adxConsume) = 0 or sum(adxClickPv) = 0 then 0 else round(cast(cast(sum(adxConsume) as float)/ sum(adxClickPv) as numeric), 4) end", "adxClickCost", "adx点击成本"),

    //adx活动访问成功率 活动访问pv/adx点击
    ADX_ACTIVITY_REQUEST_RATE("APP_ACTIVITY_REQUEST_PV", "ADX_CLICK_PV", "case when sum(appActivityRequestPV) = 0 or sum(adxClickPv) = 0 then 0 else round(cast(cast(sum(appActivityRequestPV) as float)/ sum(adxClickPv) as numeric), 4) end", "adxActivityRequestRate", "adx活动访问成功率"),

    //活动首屏唤醒成功率 活动首屏pv/活动访问PV
    ACTIVITY_WAKE_SUCCESS_RATE("ACTIVITY_WAKE_PV", "APP_ACTIVITY_REQUEST_PV", "case when sum(activityWakePv) = 0 or sum(appActivityRequestPV) = 0 then 0 else round(cast(cast(sum(activityWakePv) as float)/ sum(appActivityRequestPV) as numeric), 4) end", "activityWakeSuccessRate", "活动首屏唤醒成功率"),

    //活动加载成功率 活动加载完成PV/活动访问PV
    ACTIVITY_LOAD_SUCCESS_RATE("ACTIVITY_LOAD_PV", "APP_ACTIVITY_REQUEST_PV", "case when sum(activityLoadPv) = 0 or sum(appActivityRequestPV) = 0 then 0 else round(cast(cast(sum(activityLoadPv) as float)/ sum(appActivityRequestPV) as numeric), 4) end", "activityLoadSuccessRate", "活动加载成功率"),

    //活动参与率（PV）PV活动参与/活动访问PV
    ACTIVITY_PV_JOIN_RATE("APP_ACTIVITY_JOIN_RID", "APP_ACTIVITY_REQUEST_PV", "case when sum(appActivityJoinRid) = 0 or sum(appActivityRequestPV) = 0 then 0 else round(cast(cast(sum(appActivityJoinRid) as float)/sum(appActivityRequestPV) as numeric), 4) end", "activityPvJoinRate", "活动参与率（PV）"),

    //活动参与率（UV）活动参与UV/活动访问UV
    ACTIVITY_UV_JOIN_RATE("APP_ACTIVITY_JOIN_UV", "APP_ACTIVITY_REQUEST_UV", "case when sum(appActivityJoinUV) = 0 or sum(appActivityRequestUV) = 0 then 0 else round(cast(cast(sum(appActivityJoinUV) as float)/ sum(appActivityRequestUV) as numeric), 4) end", "activityUvJoinRate", "活动参与率（UV）"),

    //活动复参 活动参与pv/活动参与UV
    ACTIVITY_REJOIN_RATE("APP_ACTIVITY_JOIN_PV", "APP_ACTIVITY_JOIN_UV", "case when sum(appActivityJoinPV) = 0 or sum(appActivityJoinUV) = 0 then 0 else round(cast(cast(sum(appActivityJoinPV) as float)/sum(appActivityJoinUV) as numeric), 4) end", "activityJoinRate", "活动复参"),

    //券请求成功率 券请求次数/活动参与pv
    COUPON_REQUEST_SUCCESS_RATE("COUPON_REQUEST_PV", "APP_ACTIVITY_JOIN_PV", "case when sum(couponRequestPV) = 0 or sum(appActivityJoinPV) = 0 then 0 else round(cast(cast(sum(couponRequestPV) as float)/sum(appActivityJoinPV) as numeric), 4) end", "couponRequestSuccessRate", "券请求成功率"),

    //发券成功率 发券pv/券请求次数
    LAUNCH_SUCCESS_RATE("LAUNCH_COUPON_PV", "COUPON_REQUEST_PV", "case when sum(launchCouponPV) = 0 or sum(couponRequestPV) = 0 then 0 else round(cast(cast(sum(launchCouponPV) as float)/sum(couponRequestPV) as numeric), 4) end", "launchSuccessRate", "发券成功率"),

    //付费券占比 付费券/发券pv
    PAY_COUPON_RATE("LAUNCH_PAY_COUPON_PV", "LAUNCH_COUPON_PV", "case when sum(launchPayCouponPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchPayCouponPV) as float)/sum(launchCouponPV) as numeric), 4) end", "payCouponRate", "付费券占比"),

    //免费券占比 免费券/发券pv
    FREE_COUPON_RATE("LAUNCH_FREE_COUPON_PV", "LAUNCH_COUPON_PV", "case when sum(launchFreeCouponPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchFreeCouponPV) as float)/ sum(launchCouponPV) as numeric), 4) end", "freeCouponRate", "免费券占比 "),

    //作弊填充占比 风控发券/发券pv
    RISK_COUPON_RATE("RISK_LAUNCH_COUPON_PV", "LAUNCH_COUPON_PV", "case when sum(riskLaunchCouponPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(riskLaunchCouponPV) as float)/ sum(launchCouponPV) as numeric), 4) end", "riskCouponRate", "作弊填充占比"),

    //广告消耗/发券pv
    ARPU("CONSUME", "LAUNCH_COUPON_PV", "case when sum(consume) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(consume) as float)/ sum(launchCouponPV) as numeric), 4) end", "arpu", "arpu"),

    //作弊消耗占比 消耗/发券pv
    RISK_CONSUME_RATE("CHEAT_CONSUME", "CONSUME", "case when sum(consume) = 0 or sum(cheatConsume) = 0 then 0 else round(cast(cast(sum(cheatConsume) as float)/ sum(consume) as numeric), 4) end", "riskConsumeRate", "作弊消耗占比"),

    //adx每入口素材点击pv发券 发券pv/adx点击
    ADX_CLICK_LAUNCH_RATE("LAUNCH_COUPON_PV", "ADX_CLICK_PV", "case when sum(adxClickPv) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchCouponPV) as float)/sum(adxClickPv) as numeric), 4) end", "adxClickLaunchRate", "adx每入口素材点击pv发券"),

    //每PV发券 发券量/活动访问pv
    ACTIVITY_REQUEST_LAUNCH_RATE("LAUNCH_COUPON_PV", "APP_ACTIVITY_REQUEST_PV", "case when sum(appActivityRequestPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchCouponPV) as float)/ sum(appActivityRequestPV) as numeric), 4) end", "activityRequestLaunchRate", ""),

    //每UV发券 发券量/活动访问uv
    ACTIVITY_REQUEST_UV_LAUNCH_RATE("LAUNCH_COUPON_PV", "APP_ACTIVITY_REQUEST_UV", "case when sum(appActivityRequestUV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(launchCouponPV) as float)/ sum(appActivityRequestUV) as numeric), 4) end", "activityRequestUvLaunchRate", "每PV发券"),

    //券曝光率 券曝光/发券
    COUPON_EXPOSURE_RATE("COUPON_EXPOSURE_PV", "LAUNCH_COUPON_PV", "case when sum(couponExposurePV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(couponExposurePV) as float)/ sum(launchCouponPV) as numeric), 4) end", "couponExposureRate", "券曝光率"),

    //adx每入口素材点击pv点券 计费点击pv/adx点击
    ADX_CLICK_EFCLICK_RATE("COUPON_EFFECT_CLICK_PV", "ADX_CLICK_PV", "case when sum(couponEffectClickPV) = 0 or sum(adxClickPv) = 0 then 0 else round(cast(cast(sum(couponEffectClickPV) as float)/sum(adxClickPv) as numeric), 4) end", "adxClickEfclickRate", "adx每入口素材点击pv点券"),

    //每PV点券 发券量/活动访问pv
    ACTIVITY_REQUEST_EFCLICK_RATE("COUPON_EFFECT_CLICK_PV", "APP_ACTIVITY_REQUEST_PV", "case when sum(couponEffectClickPV) = 0 or sum(appActivityRequestPV) = 0 then 0 else round(cast(cast(sum(couponEffectClickPV) as float)/ sum(appActivityRequestPV) as numeric), 4) end", "activityRequestEfclickRate", "每PV点券"),

    //每UV点券 发券量/活动访问uv
    ACTIVITY_REQUEST_UV_EFCLICK_RATE("COUPON_EFFECT_CLICK_PV", "APP_ACTIVITY_REQUEST_UV", "case when sum(couponEffectClickPV) = 0 or sum(appActivityRequestUV) = 0 then 0 else round(cast(cast(sum(couponEffectClickPV) as float)/sum(appActivityRequestUV) as numeric), 4) end", "activityRequestUvEfclickRate", "每UV点券"),

    //券点击率 券点击/发券
    COUPON_CLICK_RATE("COUPON_EFFECT_CLICK_PV", "LAUNCH_COUPON_PV", "case when sum(couponEffectClickPV) = 0 or sum(launchCouponPV) = 0 then 0 else round(cast(cast(sum(couponEffectClickPV) as float)/ sum(launchCouponPV) as numeric), 4) end", "couponClickRate", "券点击率"),

    //adx每入口素材点击pv消耗 券消耗/adx点击
    ADX_CLICK_CONSUME("CONSUME", "ADX_CLICK_PV", "case when sum(consume) = 0 or sum(adxClickPv) = 0 then 0 else round(cast(cast(sum(consume) as float)/ sum(adxClickPv) as numeric), 4) end", "adxClickConsume", "adx每入口素材点击pv消耗"),

    //每PV券消耗 券消耗/活动访问pv
    ACTIVITY_REQUEST_CONSUME("CONSUME", "APP_ACTIVITY_REQUEST_PV", "case when sum(consume) = 0 or sum(appActivityRequestPV) = 0 then 0 else round(cast(cast(sum(consume) as float)/ sum(appActivityRequestPV) as numeric), 4) end", "activityRequestConsume", "每PV券消耗"),

    //每UV券消耗 券消耗/活动访问uv
    ACTIVITY_REQUEST_UV_CONSUME("CONSUME", "APP_ACTIVITY_REQUEST_UV", "case when sum(consume) = 0 or sum(appActivityRequestUV) = 0 then 0 else round(cast(cast(sum(consume) as float)/ sum(appActivityRequestUV) as numeric), 4) end", "activityRequestUvConsume", "每UV券消耗"),

    //点击单价 券消耗/券点击
    COUPON_CLICK_COST("CONSUME", "COUPON_EFFECT_CLICK_PV", "case when sum(consume) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(consume) as float)/ sum(couponEffectClickPV) as numeric), 4) end", "couponClickCost", "点击单价"),

    //落地页到达率 落地页曝光/券有效点击量
    LP_ACCESS_RATE("LP_EXPOSE_PV", "COUPON_EFFECT_CLICK_PV", "case when sum(lpExposePV) = 0 or sum(couponEffectClickPV) = 0 then 0 else round(cast(cast(sum(lpExposePV) as float)/sum(couponEffectClickPV) as numeric), 4) end", "lpAccessRate", "落地页到达率"),

    //落地页转化率 落地页转化/落地页曝光
    LP_EFFECT_RATE("LP_CLICK_PV", "LP_EXPOSE_PV", "case when sum(lpClickPV) = 0 or sum(lpExposePV) = 0 then 0 else round(cast(cast(sum(lpClickPV) as float)/ sum(lpExposePV) as numeric), 4) end", "lpEffectRate", "落地页转化率"),
    ;


    //指标-分子
    private String numerator;

    //指标-分母
    private String denominator;

    //指标sql代码段
    private String metricSql;

    //指标名
    private String fieldName;

    //指标解释说明
    private String desc;

    private static List<String> enumList = new ArrayList<>();

    HologresCalculateMetricEnum(String numerator, String denominator, String metricSql, String fieldName, String desc) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.metricSql = metricSql;
        this.fieldName = fieldName;
        this.desc = desc;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getNumerator() {
        return numerator;
    }

    public String getDenominator() {
        return denominator;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getDesc() {
        return desc;
    }

    public static List<String> getEnumList() {
        return enumList;
    }

    static {
        HologresCalculateMetricEnum[] values = HologresCalculateMetricEnum.values();
        for (HologresCalculateMetricEnum value : values) {
            enumList.add(value.toString());
        }
    }
}