package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum LabAdxLogDetailDayEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    ADX_LOG_TYPE("adx_log_type", "adx日志类型 4:竞价请求 3:竞价返回 2:竞价成功 0:券曝光 1:券点击"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    //测试平台实验组id
    TEST_GROUP_ID("test_group_id", "测试平台实验组id"),

    //测试平台测试层编码
    TEST_LAYER_CODE("test_layer_code", "测试平台测试层编码"),

    //测试平台实验计划ID
    TEST_PLAN_ID("test_plan_id", "测试平台实验计划ID");


    //hologres 中表定义的字段名称
    private String tableFieldName;

    //字段备注
    private String desc;

    LabAdxLogDetailDayEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
