package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class BigdataCatUtil {

    /**
     * 对callback内部执行的代码加上cat监控
     *
     * @param callback 要监控耗时的代码段
     * @param type 大类
     * @param name 小类
     * @param <T> 返回对象
     * @return 结果
     */
    public static <T> T executeInCatTransaction(CatUtils.Callback<T> callback, String type, String name) {
        try {
            return CatUtils.executeInCatTransaction(callback, type, name);
        } catch (Throwable throwable) {
            if (throwable instanceof NullPointerException) {
                log.info("cat util error null", throwable);
            } else {
                log.error("cat util error,", throwable);
            }
        }

        return null;
    }

    /**
     * cat 业务监控埋点
     * @param name 埋点名称
     */
    public static void logMetricForCount(String name) {
        if(CatUtils.isCatEnabled()) {
            Cat.logMetricForCount(name);
        }
    }

    /**
     * cat 事件埋点
     * @param type 大类
     * @param name 小类
     */
    public static void logEvent(String type, String name) {
        if(CatUtils.isCatEnabled()) {
            Cat.logEvent(type, name);
        }
    }

}
