package cn.com.duiba.bigdata.common.biz.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xugf
 * hologres-兑吧直播数据
 */
@Data
public class DuibaLiveDto implements Serializable {

    private static final long serialVersionUID = -3590318173616547479L;

    //维度
    //统计时间段 格式(yyyy-MM-dd HH:mm:ss)
    private String timeSegment;

    //直播id
    private String liveId;

    //代理人id
    private String agentId;

    //线索员id
    private String clueCollectorId;

    //是否到场：0表示未到场，1表示到场
    private String present;

    //是否直接邀请：0表示裂变邀请，1表示直接邀请
    private String directly;

    //是否预约页预约：0表示未预约，1表示预约
    private String appointment;

    //渠道id
    private String channelId;

    //邀请类型：1-直播前邀请 2-直播中邀请 3-直播结束后邀请
    private String invitationType;

    //互动类型：1-分享 2-关注 3-预约下一场直播
    private String interactType;

    //商品id
    private String goodsId;

    //位置id，对应dmp埋点
    private String positionId;

    //红包id
    private String redPacketId;

    //是否满足收手气王条件 0:表示不满足 1:表示满足
    private String isStandard;


    //基础指标
    //总的邀请人数，包含直播前和直播中
    private Long inviteUV;

    //直播预约人数
    private Long appointmentUV;

    //直播预约并到场的人数
    private Long appointmentPresentUV;

    //直播到场人数
    private Long presentUV;

    //客户经理邀请的人数
    private Long agentInviteUV;

    //通过渠道邀请的人数
    private Long channelInviteUV;

    //裂变邀请人数
    private Long fissionInviteUV;

    //直接邀请并到场的人数
    private Long directPresentUV;

    //裂变邀请并到场的人数
    private Long fissionPresentUV;

    //直播前-邀请人数
    private Long beforeInviteUV;

    //直播前-客户经理邀请的人数
    private Long beforeAgentInviteUV;

    //直播前-通过渠道邀请的人数
    private Long beforeChannelInviteUV;

    //直播前-直接邀请的人数
    private Long beforeDirectInviteUV;

    //直播前-裂变邀请人数
    private Long beforeFissionInviteUV;

    //直播中-邀请人数
    private Long livingInviteUV;

    //直播中-客户经理邀请的人数
    private Long livingAgentInviteUV;

    //直播中-通过渠道邀请的人数
    private Long livingChannelInviteUV;

    //直播中-裂变邀请人数
    private Long livingFissionInviteUV;

    //参与邀请的客户经理人数
    private Long agentUV;

    //客户经理-预约的人数
    private Long agentAppointmentUV;

    //客户经理-裂变邀请人数
    private Long agentFissionInviteUV;

    //渠道-预约的人数
    private Long channelAppointmentUV;

    //渠道-到场的人数
    private Long channelPresentUV;

    //渠道-裂变的人数
    private Long channelFissionInviteUV;

    //观看互动-观看人数
    private Long watchUV;

    //观看互动-分享次数
    private Long sharePV;

    //观看互动-分享人数
    private Long shareUV;

    //观看互动-关注直播间人数
    private Long focusLiveUV;

    //观看互动-预约下场直播人数
    private Long appointmentLiveUV;

    //红包-红包领取人数
    private Long moneyReceiverPV;

    //红包-红包领取金额，单位是分
    private Long moneyReceiveAmount;

    //红包-手气王红包领取人数
    private Long bigMoneyReceiverPV;

    //红包-获得助力的人数
    private Long moneyInviteUV;

    //红包-助力人数
    private Long moneyHelpUV;

    //商品-商品点击次数
    private Long goodsClickPV;

    //商品-商品点击人数
    private Long goodsClickUV;


    //计算类指标
    //预约率 直播预约人数/直播前-邀请人数
    private Double appointmentRate;

    //到场率 直播到场人数/总的邀请人数，包含直播前和直播中
    private Double presentRate;

    //裂变系数 裂变邀请并到场的人数/直接邀请并到场的人数
    private Double fissionRate;

    //直播前-裂变系数 直播前-裂变邀请人数/直播前-直接邀请的人数
    private Double beforeFissionRate;

    //预约到场率 直播预约并到场的人数/直播预约人数
    private Double appointmentPresentRate;

    //客户经理人均邀请人数 客户经理邀请的人数/参与邀请的客户经理人数
    private Double agentInviteRate;

    //客户经理-预约率 客户经理-预约的人数/直播前-客户经理邀请的人数
    private Double agentAppointmentRate;

    //渠道-预约率 渠道-预约的人数/直播前-通过渠道邀请的人数
    private Double channelAppointmentRate;

    //渠道-到场率 渠道-到场的人数/通过渠道邀请的人数
    private Double channelPresentRate;

    //人均分享次数 观看互动-分享次数/观看互动-分享人数
    private Double shareRate;

    //关注率 观看互动-关注直播间人数/观看互动-观看人数
    private Double focusLiveRate;


}
