package cn.com.duiba.bigdata.common.biz.enums.tables.duiba_live;

/**
 * @author xugf 2020-05-20
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaLiveInvitationLogEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    LIVE_ID("live_id", "直播id"),

    LIVE_VISITOR_ID("live_visitor_id", "直播用户id"),

    AGENT_ID("agent_id", "代理人id"),

    CLUE_COLLECTOR_ID("clue_collector_id", "线索员id"),

    PRESENT("present", "是否到场：0表示未到场，1表示到场"),

    DIRECTLY("directly", "是否直接邀请：0表示裂变邀请，1表示直接邀请"),

    APPOINTMENT("appointment", "是否预约页预约：0表示未预约，1表示预约"),

    CHANNEL_ID("channel_id", "渠道id"),

    INVITATION_TYPE("invitation_type", "邀请类型：1-直播前邀请 2-直播中邀请 3-直播结束后邀请")








    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaLiveInvitationLogEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
