/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.entity.redis.KeyIndex;
import cn.com.duiba.bigdata.common.biz.enums.DimStatisticsIndexEnum;
import cn.com.duiba.bigdata.common.biz.utils.MD5Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigdataUtil {
    private static final Logger log = LoggerFactory.getLogger(BigdataUtil.class);

    public static boolean numberCheck(String str) {
        return !StringUtils.isBlank((CharSequence)str) && str.matches("[0-9]*");
    }

    public static JSONObject parseJson(Object content) {
        JSONObject jsonObject = null;
        if (content == null) {
            return null;
        }
        if (content instanceof String) {
            String json = (String)content;
            jsonObject = JSON.parseObject((String)json);
        } else if (content instanceof JSONObject) {
            jsonObject = (JSONObject)content;
        }
        return jsonObject;
    }

    public static String getString(JSONObject object, String key) {
        if (object == null) {
            return null;
        }
        String str = object.getString(key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        if ("null".equalsIgnoreCase(str)) {
            return null;
        }
        return str;
    }

    public static String getMD5HbaseRowkey(String ... strs) {
        String key = BigdataUtil.getJoinStr(strs);
        return StringUtils.isBlank((CharSequence)key) ? null : MD5Util.computeMD5(key).substring(0, 4) + "-" + key;
    }

    public static String getJoinStr(Object ... obj) {
        if (obj.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object str : obj) {
            sb.append(str).append("_");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static List<String> getTimeList(String pattern, int before) {
        DateTime dateTime = new DateTime();
        ArrayList<String> timeList = new ArrayList<String>();
        for (int i = 0; i < before; ++i) {
            if ("yyyyMMdd".equals(pattern)) {
                timeList.add(dateTime.plusDays(-i).toString(pattern));
                continue;
            }
            if ("yyyyMMddHH".equals(pattern)) {
                timeList.add(dateTime.plusHours(-i).toString(pattern));
                continue;
            }
            if (!"yyyyMMddHHmm".equals(pattern)) continue;
            timeList.add(dateTime.plusMinutes(-i).toString(pattern));
        }
        return timeList;
    }

    public static <T> Map<String, Long> getBackendCntMap(Map<String, T> data) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            for (String key : data.keySet()) {
                if (!BigdataUtil.numberCheck(key)) continue;
                map.put(key, Long.valueOf(data.get(key).toString()));
            }
        }
        catch (NumberFormatException e) {
            log.error("get backend data error", (Throwable)e);
        }
        return map;
    }

    public static <T extends Number> String division(T dividend, T divisor, int digit) {
        String result = "0";
        try {
            if (dividend != null && divisor != null) {
                double divisorDouble = divisor.doubleValue();
                double dividendDouble = dividend.doubleValue();
                if (divisorDouble != 0.0) {
                    result = new BigDecimal(dividendDouble / divisorDouble).setScale(digit, 4).stripTrailingZeros().toPlainString();
                }
            }
        }
        catch (Exception e) {
            log.error("division error", (Throwable)e);
        }
        return result;
    }

    public static String getBigdataRedisKey(String prefix, String suffix, Object ... array) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{prefix})) {
            log.error("GetRedisKeyUDF prefix is null");
            return null;
        }
        if (array == null || array.length == 0) {
            log.error("GetRedisKeyUDF eval, please set dim and value");
            return null;
        }
        if (array.length % 2 != 0) {
            log.error("GetRedisKeyUDF eval, array.length % 2 != 0");
            return null;
        }
        ArrayList<KeyIndex> list = new ArrayList<KeyIndex>();
        for (int i = 0; i < array.length; i += 2) {
            String key = null;
            String value = null;
            if (array[i] != null) {
                key = array[i].toString();
            }
            if (array[i + 1] != null) {
                value = array[i + 1].toString();
            }
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
                return null;
            }
            Integer index = DimStatisticsIndexEnum.INSTANCE.getDimIndex(key);
            if (index == null) {
                log.error("key = {} is error, please check it.", (Object)key);
                return null;
            }
            KeyIndex keyIndex = new KeyIndex(key, value, index);
            list.add(keyIndex);
        }
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        sb.append(prefix.toUpperCase()).append("_");
        for (KeyIndex info : list) {
            sb.append(info.getValue()).append("_");
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String getHbaseDataToString(Result result, String family, String column) {
        String value = "";
        if (result != null && result.containsColumn(family.getBytes(), column.getBytes())) {
            value = Bytes.toString((byte[])result.getValue(family.getBytes(), column.getBytes()));
        }
        return value;
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static Map<String, Map<String, String>> getHbaseStringDataMap(Map<String, List<String>> hbaseRowkeyMap, Result[] results, String family) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        if (MapUtils.isEmpty(hbaseRowkeyMap) || results == null) {
            return map;
        }
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            String rowKey = Bytes.toString((byte[])result.getRow());
            List<String> columnList = hbaseRowkeyMap.get(rowKey);
            for (String column : columnList) {
                BigdataUtil.putHbaseColumnData(columnMap, column, BigdataUtil.getHbaseDataToString(result, family, column));
            }
            map.put(rowKey, columnMap);
        }
        return map;
    }

    public static void putHbaseColumnData(Map<String, String> map, String column, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            map.put(column, value);
        }
    }

    public static String parseUrlParam(String str, String key) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if (!str.startsWith(key)) {
                key = "&" + key;
            }
            if (str.contains(key)) {
                return str.substring(0, (str = str.substring(str.indexOf(key) + key.length())).contains("&") ? str.indexOf("&") : str.length());
            }
        }
        return null;
    }

    public static Map<String, Map<String, Long>> getHbaseLongDataMap(List<String> rowkeyList, Result[] results) {
        if (rowkeyList != null && rowkeyList.size() > 0) {
            HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
            for (int i = 0; i < rowkeyList.size(); ++i) {
                Cell[] cells;
                HashMap<String, Long> columnMap = new HashMap<String, Long>();
                String rowkey = rowkeyList.get(i);
                Result result = results[i];
                if (result == null || result.isEmpty()) continue;
                for (Cell cell : cells = result.rawCells()) {
                    String column = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                    Long value = Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                    columnMap.put(column, value);
                }
                map.put(rowkey, columnMap);
            }
            return map;
        }
        return null;
    }

    public static Map<String, Map<String, String>> getHbaseStringDataMap(List<String> rowkeyList, Result[] results) {
        if (rowkeyList != null && rowkeyList.size() > 0) {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            for (int i = 0; i < rowkeyList.size(); ++i) {
                Cell[] cells;
                HashMap<String, String> columnMap = new HashMap<String, String>();
                String rowkey = rowkeyList.get(i);
                Result result = results[i];
                if (result == null || result.isEmpty()) continue;
                for (Cell cell : cells = result.rawCells()) {
                    String column = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                    String value = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                    BigdataUtil.putHbaseColumnData(columnMap, column, value);
                }
                map.put(rowkey, columnMap);
            }
            return map;
        }
        return null;
    }

    public static <T extends Number> Double avg(List<T> set, boolean skip) {
        int i = 0;
        double result = 0.0;
        for (Number num : set) {
            if (num == null) continue;
            double value = num.doubleValue();
            if (skip && value == 0.0) continue;
            ++i;
            result += value;
        }
        if (i != 0) {
            return result / (double)i;
        }
        return 0.0;
    }
}

