package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.constant.TimeoutKeys;

public enum MinuteRediskeys {
    //日志数量
    M001(TimeoutKeys.TIMEOUT_3_HOUR),

    //哪吒统计ctr
    M002(TimeoutKeys.TIMEOUT_1_HOUR),

    //哪吒统计cvr
    M003(TimeoutKeys.TIMEOUT_1_HOUR),

    //样本数
    M004(TimeoutKeys.TIMEOUT_1_HOUR),

    //单维度统计
    //Adx资源位 排除直投
    M101(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx创意
    M102(TimeoutKeys.TIMEOUT_1_HOUR),

    //Adx资源位 全局
    M103(TimeoutKeys.TIMEOUT_1_HOUR),

    //Adx资源位 直投
    M104(TimeoutKeys.TIMEOUT_1_HOUR),

    //广告
    M105(TimeoutKeys.TIMEOUT_1_HOUR),


    //2个维度
    //adx资源位+出价类型
    M202(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx资源位+adx交易模式
    M203(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx的资源位+竞价过滤类型
    M204(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx的资源位+竞价过滤类型
    M205(TimeoutKeys.TIMEOUT_1_HOUR),

    //创意id + 素材id
    M206(TimeoutKeys.TIMEOUT_1_HOUR),

    //资源位id + 素材id
    M207(TimeoutKeys.TIMEOUT_1_HOUR),

    //广告位+美团adx实验分组 美团算法调价
    M208(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx创意 + 百度App_id 全局
    M209(TimeoutKeys.TIMEOUT_1_HOUR),

    //资源位 + 百度App_id 全局
    M210(TimeoutKeys.TIMEOUT_1_HOUR),

    //资源位 + 百度App_id 直投
    M211(TimeoutKeys.TIMEOUT_1_HOUR),

    //资源位 + 百度App_id 排除直投
    M212(TimeoutKeys.TIMEOUT_1_HOUR),

    //广告+媒体
    M213(TimeoutKeys.TIMEOUT_1_HOUR),

    //百度appId+分桶
    M214(TimeoutKeys.TIMEOUT_1_HOUR),

    //3个维度
    //adx创意+策略+出价区间
    M303(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx资源位+出价类型+adx交易模式
    M304(TimeoutKeys.TIMEOUT_1_HOUR),

    //广告位+广告+美团adx实验分组
    M305(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx创意id+实验id+实验分组 排除直投
    M306(TimeoutKeys.TIMEOUT_1_HOUR),

    //adx资源位id+实验id+实验分组 排除直投
    M307(TimeoutKeys.TIMEOUT_1_HOUR),

    //广告位+百度appId+分桶
    M308(TimeoutKeys.TIMEOUT_1_HOUR),

    //4个维度
    //创意id+百度appId+实验id+实验分组 排除直投
    M401(TimeoutKeys.TIMEOUT_1_HOUR),

    //资源位id+百度appId+实验id+实验分组 排除直投
    M402(TimeoutKeys.TIMEOUT_1_HOUR),

    //资源位+创意素材+实验id+实验分组+创意尺寸 排除直投
    M501(TimeoutKeys.TIMEOUT_1_HOUR),

    //资源位+广告位素材标签+实验id+实验分组+创意尺寸 排除直投
    M502(TimeoutKeys.TIMEOUT_1_HOUR);



    private final int timeout;

    private MinuteRediskeys(int timeout) {
        this.timeout = timeout;
    }

    public String getPrefix() {
        return super.toString();
    }

    public int getTimeout() {
        return timeout;
    }

    @Override
    public String toString() {
        return super.toString() + "_";
    }
}
