package cn.com.duiba.bigdata.common.biz.dto;

import cn.com.duiba.bigdata.common.biz.utils.BigdataUtil;
import lombok.Data;

import java.io.Serializable;
import java.text.DecimalFormat;

/**
 * @author xugf
 * Hologres 返回结果转化的对象
 */
@Data
public class HologresResultDto implements Serializable {

    private static final long serialVersionUID = 6330017189699677782L;

    //维度
    //统计时间段 格式(yyyy-MM-dd HH:mm:ss)
    private String timeSegment;

    //媒体id
    private String appId;

    //广告位id
    private String slotId;

    //活动id
    private String activityId;

    //广告id
    private String advertId;

    //广告推广计划id
    private String advertPlanId;

    //素材ID
    private String materialId;

    //广告定向配置id
    private String orientationId;

    //广告主账户id
    private String accountId;

    //代理商id
    private String agentId;

    //ADX推广组id
    private String groupId;

    //ADX资源位id
    private String resourceId;

    //ADX创意id
    private String ideaId;

    //ADX创意素材id
    private String ideaMaterialId;

    //ADX创意素材类型
    private String ideaMaterialType;

    //创建App的来源
    private String appSource;

    //媒体性质 1-在线KA,2-潜力KA,3-普通媒体
    private String appLevel;

    //媒体类型 1-android，2-ios，3-js
    private String appType;

    //广告位接入方式 1:sdk,2.手动投放（接入api),3.手动投放（不接入api）
    private String slotAccessType;

    //目标转化类型（广告配置的一个属性）
    private String targetEffectType;

    //1表示表单类广告
    private String formAdvert;

    //是否免费 (0:收费 1:免费)
    private String isFree;

    //ae区域  1-华东，2-华北 3-其他
    private String aeArea;

    //aeId
    private String aeId;

    //广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）
    private String advertType;

    //活动投放类型 1-配置包插件活动,2-活动工具,3-直投页,4-展示广告,5-浮标,6-增值广告,7-活动直投落地页,8-激励视屏,9-新激励视屏,10-增值,11-dp广告
    private String slotActivityType;

    //活动来源 (0-兑吧 1-推啊)
    private String activitySource;

    //广告位投放活动的类型（1-插件工具、2-普通活动、3-直投页、4-自定义活动）
    private String activityType;

    //活动投放模式（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）
    private String activityReleaseMode;

    //广告位上直投活动的投放方式：仅投1 优投人工2 优投算法3 纯算法4 其他0
    private String activityReleaseSubMode;

    //广告位投放内容类型 1:活动、2：直投页、3：自定义活动
    private String releaseContentType;

    //adx投放方式 0依次 1按比例 2按算法
    private String adxPutType;

    //生效的主体类型，1-杭州推啊，2-霍尔果斯推啊
    private String companyId;

    //风控类型 0：正常，1：用户作弊，2：广告位作弊
    private String riskType;

    //广告位素材id
    private String slotMaterialId;

    //广告位素材投放方式：0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级
    private String slotMaterialPutType;

    //插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0
    private String pluginPutType;

    //媒体一级行业
    private String appFirstTradeId;

    //媒体二级行业
    private String appSecondTradeId;

    //媒体流量标签
    private String appFlowTag;

    //广告行业
    private String advertTradeTagId;

    //广告资源
    private String advertResourceTagId;

    //媒体账号id
    private String developerId;

    //流量类型
    private String flowType;

    //活动投放方式-大类（1:测试 2:算法 3:灰度测试 4:手投）
    private String activityPutType;

    //sdk version 版本
    private String sdkVersion;

    //补丁版本
    private String patchVersion;

    //奔溃数据类型
    private String crashType;

    //操作系统
    private String ua;

    //活动皮肤是否出激励视频 1-出 0-不出
    private Integer withEncVedio;

    // --测试平台实验组id
    private String testGroupId;

    //--测试平台测试层编码
    private String testLayerCode;

    //--测试平台实验计划ID
    private String testPlanId;

    //过滤原因
    private String filterType;

    //胜出广告配置的行业
    private String winAdvertTradeId;

    //广告配置竞价排序分
    private String rankScore;

    //发券场景
    private String launchScene;

    //adx联盟流量媒体id
    private String adxAppId;

    //基础指标
    //广告位曝光pv
    private Long slotExposurePV;

    //广告位曝光uv
    private Long slotExposureUV;

    //广告位点击pv
    private Long slotClickPV;

    //广告位点击uv
    private Long slotClickUV;

    //广告位访问pv
    private Long slotVisitPV;

    //广告位访问uv
    private Long slotVisitUV;

    //活动线-活动请求pv
    private Long activityRequestPV;

    //活动线-活动请求uv
    private Long activityRequestUV;

    //活动线-活动参与pv
    private Long activityJoinPV;

    //活动线-活动参与uv
    private Long activityJoinUV;

    //媒体线-活动请求pv
    private Long appActivityRequestPV;

    //媒体线-活动请求uv
    private Long appActivityRequestUV;

    //媒体线-活动参与pv
    private Long appActivityJoinPV;

    //媒体线-活动参与uv
    private Long appActivityJoinUV;

    //媒体线-pv活动参与
    private Long appActivityJoinRid;

    //券请求pv
    private Long couponRequestPV;

    //券请求uv
    private Long couponRequestUV;

    //发券量pv
    private Long launchCouponPV;

    //风控免费券发券量pv
    private Long riskLaunchCouponPV;

    //付费券发券量pv
    private Long launchPayCouponPV;

    //免费券发券量pv
    private Long launchFreeCouponPV;

    //券曝光pv
    private Long couponExposurePV;

    //券普通点击pv
    private Long couponClickPV;

    //券普通点击uv
    private Long couponClickUV;

    //券计费点击pv
    private Long couponEffectClickPV;

    //消耗（单位分）
    private Long consume;

    //作弊消耗（单位分）
    private Long cheatConsume;

    public Double getConsumeYuan() {
        if (consume == null) {
            return 0D;
        }
        return consume / 100.0;
    }

    //消耗（单位元）
    private Double consumeYuan;

    //增值广告消耗
    private Long encourageConsume;

    //落地页曝光pv
    private Long lpExposePV;

    //落地页曝光uv
    private Long lpExposeUV;

    //落地页转化pv
    private Long lpClickPV;

    //落地页转化uv
    private Long lpClickUV;

    //表单类落地页转化pv
    private Long formLpClickPV;

    //表单类券点击pv
    private Long formCouponClickPV;

    //下载成功数为SDK下载补丁成功数量
    private Long downPatchSuccUv;

    //生效数为补丁成功生效的数量
    private Long downSuccEffectUv;

    //SDK版本总数为该sdk版本总用户数
    private Long sdkUv;

    //视频活动参与pv
    private Long videoActivityJoinPV;

    //视频活动参与uv
    private Long videoActivityJoinUV;

    //看视频按钮点击次数
    private Long watchVideoClickPV;

    //看视频弹窗点击关闭按钮次数
    private Long closeWindowClickPV;

    //看视频弹窗曝光次数
    private Long windowExposurePV;

    //看视频按钮点击uv
    private Long watchVideoClickUV;

    //看视频弹窗点击关闭按钮uv
    private Long closeWindowClickUV;

    //看视频弹窗曝光uv
    private Long windowExposureUV;

    //启动数
    private Long totalTimesPv;

    //启动设备数
    private Long totalDevicesUv;

    //奔溃次数
    private Long crashTimesPv;

    //奔溃设备数
    private Long crashDevicesUv;

    //后端转化类型-安装pv
    private Long installPv;

    //后端转化类型-安装uv
    private Long installUv;

    //后端转化类型-启动pv
    private Long startPv;

    //后端转化类型-启动uv
    private Long startUv;

    //后端转化类型-注册pv
    private Long registePv;

    //后端转化类型-注册uv
    private Long registeUv;

    //后端转化类型-激活pv
    private Long activatePv;

    //后端转化类型-激活uv
    private Long activateUv;

    //后端转化类型-登录pv
    private Long loginPv;

    //后端转化类型-登录uv
    private Long loginUv;

    //后端转化类型-付费pv
    private Long payPv;

    //后端转化类型-付费uv
    private Long payUv;

    //后端转化类型-进件pv
    private Long entryPv;

    //后端转化类型-进件uv
    private Long entryUv;

    //后端转化类型-完件pv
    private Long finishPv;

    //后端转化类型-完件uv
    private Long finishUv;

    //后端转化类型-签收pv
    private Long signPv;

    //后端转化类型-签收uv
    private Long signUv;

    //后端转化类型-拒签pv
    private Long denyPv;

    //后端转化类型-拒签uv
    private Long denyUv;

    //后端转化类型-出单pv
    private Long orderPv;

    //后端转化类型-订单取消pv
    private Long cancelPv;

    //活动唤醒pv
    private Long activityWakePv;

    //活动唤醒uv
    private Long activityWakeUv;

    //活动加载pv
    private Long activityLoadPv;

    //活动加载uv
    private Long activityLoadUv;

    //adx曝光pv
    private Long adxExposurePv;

    //adx消耗 单位分
    private Double adxConsume;

    //adx点击
    private Long adxClickPv;

    //adx竞价成功
    private Long adxBidSuccessPv;

    //adx竞价返回
    private Long adxBidReturnPv;

    //adx最终参与竞价出价
    private Long adxFinalBidFee;

    //adx最终参与竞价
    private Long adxFinalBidPv;

    //adx竞价请求pv
    private Long adxBidRequestPv;


    //插件活动访问pv
    private Long pluginRequestPv;

    //插件活动访问uv
    private Long pluginRequestUv;

    //广告配置过滤次数
    private Long packageFilterPv;

    //广告配置进哪吒前竞价次数
    private Long packageBidPv;

    //广告配置哪吒竞价次数
    private Long packageNezhaBidPv;

    //广告配置哪吒竞价失败次数(被抢量)
    private Long packageNezhaBidFailedPv;

    //竞价ecpm总和
    private Double bidEcpmSum;

    //竞价rankScore总和
    private Double bidRankScoreSum;

    //竞价预估CTR总和
    private Double bidPreCtrSum;

    //竞价预估CVR总和
    private Double bidPreCvrSum;

    //竞价统计CTR总和
    private Double bidStatCtrSum;

    //竞价统计CVR总和
    private Double bidStatCvrSum;


    //目标转化次数
    private Long targetEffectPv;

    //目标转化消耗
    private Long targetEffectConsume;

    //平均预估CTR
    private Double preCtrAvg;

    //平均预估CVR
    private Double preCvrAvg;

    //平均统计CTR
    private Double statCtrAvg;

    //平均统计CVR
    private Double statCvrAvg;

    //平均维稳因子
    private Double factorAvg;

    //平均竞价排序分
    private Double rankScoreAvg;


    //美团adx曝光pv
    private Long meituanAdxExposurePv;

    //美团adx曝光uv
    private Long meituanAdxExposureUv;

    //美团adx消耗
    private Double meituanAdxConsume;

    //美团adx点击pv
    private Long meituanAdxClickPv;

    //美团adx点击uv
    private Long meituanAdxClickUv;

    //美团胜出媒体出价总和(1价)(分)
    private Long meituanAdxBidFeeTotal;

    //美团广告出价总和(分)
    private Long meituanAdxAdvertFeeTotal;

    //美团adx竞价成功
    private Long meituanAdxBidSuccessPv;

    //美团adx竞价返回
    private Long meituanAdxBidReturnPv;

    //美团adx竞价请求pv
    private Long meituanAdxBidRequestPv;


    //计算类指标
    //adx分成比例 adx消耗/消耗
    private Double adxDividePercent;

    //adx ROI 消耗/adx消耗
    private Double adxRoi;

    //adx竞价返回率 真实返回数/请求数
    private Double adxBidReturnRate;

    //adx竞价成功率 竞价成功数/竞价返回数
    private Double adxBidSuccessRate;

    //adx竞价成功成本 adx消耗/竞价成功数
    private Double adxBidSuccessCost;

    //adx曝光率 adx曝光/竞价成功数
    private Double adxExposureRate;

    //adx曝光成本 adx消耗/adx曝光
    private Double adxExposureCost;

    //adx点击率 adx点击/adx曝光
    private Double adxClickRate;

    //adx点击成本 adx消耗/adx点击
    private Double adxClickCost;

    //adx活动访问成功率 活动访问pv/adx点击
    private Double adxActivityRequestRate;

    //活动首屏唤醒成功率 活动首屏pv/活动访问PV
    private Double activityWakeSuccessRate;

    //活动加载成功率 活动加载完成PV/活动访问PV
    private Double activityLoadSuccessRate;

    //活动参与率（PV）PV活动参与/活动访问PV
    private Double activityPvJoinRate;

    //活动参与率（UV）活动参与UV/活动访问UV
    private Double activityUvJoinRate;

    //活动复参 活动参与pv/活动参与UV
    private Double activityJoinRate;

    //券请求成功率 券请求次数/活动参与pv
    private Double couponRequestSuccessRate;

    //发券成功率 发券pv/券请求次数
    private Double launchSuccessRate;

    //付费券占比 付费券/发券pv
    private Double payCouponRate;

    //免费券占比 免费券/发券pv
    private Double freeCouponRate;

    //作弊填充占比 风控发券/发券pv
    private Double riskCouponRate;

    //广告消耗/发券pv
    private Double arpu;

    //作弊消耗占比 消耗/发券pv
    private Double riskConsumeRate;

    //adx每入口素材点击pv发券 发券pv/adx点击
    private Double adxClickLaunchRate;

    //每PV发券 发券量/活动访问pv
    private Double activityRequestLaunchRate;

    //每UV发券 发券量/活动访问uv
    private Double activityRequestUvLaunchRate;

    //券曝光率 券曝光/发券
    private Double couponExposureRate;

    //adx每入口素材点击pv点券 计费点击pv/adx点击
    private Double adxClickEfclickRate;

    //每PV点券 发券量/活动访问pv
    private Double activityRequestEfclickRate;

    //每UV点券 发券量/活动访问uv
    private Double activityRequestUvEfclickRate;

    //券点击率 券点击/发券
    private Double couponClickRate;

    //adx每入口素材点击pv消耗 券消耗/adx点击
    private Double adxClickConsume;

    //每PV券消耗 券消耗/活动访问pv
    private Double activityRequestConsume;

    //每UV券消耗 券消耗/活动访问uv
    private Double activityRequestUvConsume;

    //点击单价 券消耗/券点击
    private Double couponClickCost;

    //落地页到达率 落地页曝光/券有效点击量
    private Double lpAccessRate;

    //落地页转化率 落地页转化/落地页曝光
    private Double lpEffectRate;

    //兑吧活动埋点日志 埋点规范：http://cf.dui88.com/pages/viewpage.action?pageId=60846606
    private String dpmA;

    private String dpmB;

    private String dpmC;

    private String dpmD;

    private String dcmA;

    private String dcmB;

    private String dcmC;

    private String dcmD;

    private String domA;

    private String domB;

    private String domC;

    private String domD;

    //兑吧活动曝光次数
    private Long duibaExposurePV;

    //兑吧活动曝光uv
    private Long duibaExposureUV;

    //兑吧活动点击次数
    private Long duibaClickPV;

    //兑吧活动点击uv
    private Long duibaClickUV;

    //adx debug工具
    //预估入口素材CTR总值
    private Double adxPreCtrTotal;

    //预估入口素材CTR pv
    private Long adxPreCtrCount;

    //统计入口素材CTR总值
    private Double adxStatCtrTotal;

    //统计入口素材CTR pv
    private Long adxStatCtrCount;

    //融合入口素材CTR总值
    private Double adxMergerCtrTotal;

    //融合入口素材CTR pv
    private Long adxMergerCtrCount;

    //预估每pv发券总值
    private Double adxPrePvLaunchTotal;

    //预估每pv发券 pv
    private Long adxPrePvLaunchCount;

    //统计每pv发券总值
    private Double adxStatPvLaunchTotal;

    //统计每pv发券 pv
    private Long adxStatPvLaunchCount;

    //融合每pv发券总值
    private Double adxMergePvLaunchTotal;

    //融合每pv发券 pv
    private Long adxMergePvLaunchCount;

    //预估arpu总值
    private Double adxPreArpuTotal;

    //预估arpu pv
    private Long adxPreArpuCount;

    //统计arpu总值
    private Double adxStatArpuTotal;

    //统计arpu pv
    private Long adxStatArpuCount;

    //融合arpu总值
    private Double adxMergerArpuTotal;

    //融合arpu pv
    private Long adxMergerArpuCount;

    //融合arpu总值
    private Double adxFactorTotal;

    //融合arpu pv
    private Long adxFactorCount;

    //adx过滤原因
    private String adxFilterType;

    //adx过滤次数
    private Long adxFilterPv;

    //降级付费出券pv
    private Long couponDegradePayPV;

    //降级免费出券pv
    private Long couponDegradeFreePV;

    //可投配置数
    private Long usableConfigNumSum;

    //可投配置数pv
    private Long usableConfigPv;

    //可投广告数
    private Long usableAdvertNumSum;

    //可投广告数pv
    private Long usableAdvertPv;

    //广告过滤阶段 1:初始有效 2:定向媒体过滤后 3:最终进入nezha
    private Integer filterStage;

    //平均可投配置数
    private Double usableConfigNumAvg;

    //平均可投广告数
    private Double usableAdNumAvg;

    //可投配置数总pv
    private Long usableConfigPvTotal;

    //广告互动大盘投放场景
    private Integer advertPutScene;

    //广告走特权库发券pv
    private Long privilegeLaunchPv;

    //媒体流量类型 1-微信,2-QQ,3-支付宝,4-其他
    private Integer appFlowType;

    //后端转化类型-注册消耗
    private Long registeConsume;

    //后端转化类型-激活消耗
    private Long activateConsume;

    //后端转化类型-付费消耗
    private Long payConsume;

    //后端转化类型-进件消耗
    private Long entryConsume;

    //后端转化类型-完件消耗
    private Long FINISH_CONSUME;

    //后端转化类型-签收消耗
    private Long signConsume;

    //落地页转化cvr
    private Double lpEffectcvr;

    //广告cvr
    private Double advertCvr;

    //广告ctr
    private Double advertCtr;

    //转化成本
    private Double effectCost;

    //付费成本
    private Double payCost;

    //进件成本
    private Double entryCost;

    //签收成本
    private Double signCost;

    //注册成本
    private Double registeCost;

    //完件成本
    private Double finishCost;

    //激活成本
    private Double activateCost;

    //注册cvr
    private Double registeCvr;

    //激活cvr
    private Double activateCvr;

    //完件cvr
    private Double finishCvr;

    //进件cvr
    private Double entryCvr;

    //签收cvr
    private Double signCvr;

    //付费cvr
    private Double payCvr;

    //ctr 券计费点击pv/曝光pv
    public Double getCtr() {
        return Double.valueOf(BigdataUtil.division(couponEffectClickPV, couponExposurePV, 4));
    }

    //落地页到达率 落地页曝光pv/计费点击pv
    public Double getLpAccessRate() {
        return Double.valueOf(BigdataUtil.division(lpExposePV, couponEffectClickPV, 4));
    }

    //CVR 落地页转化pv/计费点击pv
    public Double getCvr() {
        return Double.valueOf(BigdataUtil.division(lpClickPV, couponEffectClickPV, 4));
    }

    //启动成本（分）消耗/启动pv
    public Double getStartCost() {
        return Double.valueOf(BigdataUtil.division(consume, startPv, 4));
    }

    //启动cvr 启动pv/计费点击pv
    public Double getStartCvr() {
        return Double.valueOf(BigdataUtil.division(startPv, couponEffectClickPV, 4));
    }

    //注册成本（分）
    public Double getRegisterCost() {
        return Double.valueOf(BigdataUtil.division(consume, registePv, 4));
    }

    //注册cvr 注册pv/计费点击pv
    public Double getRegisterCvr() {
        return Double.valueOf(BigdataUtil.division(registePv, couponEffectClickPV, 4));
    }

    //激活成本（分）
    public Double getActivateCost() {
        return Double.valueOf(BigdataUtil.division(consume, activatePv, 4));
    }

    //登陆成本（分）
    public Double getLoginCost() {
        return Double.valueOf(BigdataUtil.division(consume, loginPv, 4));
    }

    //付费成本（分）
    public Double getPayCost() {
        return Double.valueOf(BigdataUtil.division(consume, payPv, 4));
    }

    //进件成本（分）
    public Double getEntryCost() {
        return Double.valueOf(BigdataUtil.division(consume, entryPv, 4));
    }

    //完件成本（分）
    public Double getFinishCost() {
        return Double.valueOf(BigdataUtil.division(consume, finishPv, 4));
    }

    //签收成本（分）
    public Double getSignCost() {
        return Double.valueOf(BigdataUtil.division(consume, signPv, 4));
    }

    //计费点击均价（分）消费/计费点击pv
    public Double getAvgClickCost() {
        return Double.valueOf(BigdataUtil.division(consume, couponEffectClickPV, 4));
    }

}
