package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaInnerLogDetailMonthEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    INNER_GROUP("inner_group", "公司业务分类，大类"),

    INNER_TYPE("inner_type", "日志分类，小类"),

    CONSUMER_ID("consumer_id", "用户id"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    ACTIVITY_ID("activity_id", "活动id"),

    COMPANY_ID("company_id", "生效的主体类型 1-杭州推啊，2-霍尔果斯推啊"),

    ADVERT_TYPE("advert_type", "广告类型 -1-互动式广告，4-展示广告，6-激励广告"),

    ADVERT_TRADE_TAG_ID("advert_trade_tag_id", "广告行业"),

    FORM_ADVERT("form_advert", "表单类广告 0表示非表单类广告 1表示表单类广告"),

    ADVERT_ID("advert_id", "广告id"),

    ORIENTATION_ID("orientation_id", "广告定向配置id 0为默认配置"),

    ADVERT_RESOURCE_TAG_ID("advert_resource_tag_id", "广告资源id"),

    IS_FREE("is_free", "是否免费广告 0:收费 1:免费"),

    TARGET_EFFECT_TYPE("target_effect_type", "广告目标转化类型"),

    AE_AREA("ae_area", "运营区域 1-华东，2-华北 3-其他"),

    AE_ID("ae_id", "运营人员id"),

    MATERIAL_ID("material_id", "素材ID"),

    ACCOUNT_ID("account_id", "广告主账户id"),

    AGENT_ID("agent_id", "代理商id"),

    APP_SOURCE("app_source", "创建App的来源  0：积分商城（兑吧） 1：广告平台（推啊）"),

    APP_LEVEL("app_level", "媒体性质 1-在线KA,2-潜力KA,3-普通媒体"),

    APP_TYPE("app_type", "媒体类型 1-在线ka 2-普通媒体 3-rtb-adx 4-rtb-非adx"),

    NEW_APP_TYPE("new_app_type", "新媒体类型 0-老媒体，1-新媒体测试发券，2-新媒体,非新媒体测试发券"),

    DEVELOPER_ID("developer_id", "媒体账号id"),

    APP_FIRST_TRADE_ID("app_first_trade_id", "媒体一级行业"),

    APP_SECOND_TRADE_ID("app_second_trade_id", "媒体二级行业"),

    APP_FLOW_TAG("app_flow_tag", "媒体流量标签"),

    SLOT_MATERIAL_ID("slot_material_id", "广告位素材id"),

    SLOT_MATERIAL_PUT_TYPE("slot_material_put_type", "广告位素材投放方式 0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级"),

    ACTIVITY_SOURCE("activity_source", "活动来源 0-兑吧 1-推啊"),

    ACTIVITY_TYPE("activity_type", "广告位投放活动类型 1-常规活动，2-自定义活动（非深度），3-直投页，4-深度互动，5-原生互动，6-激励互动"),

    ACTIVITY_PUT_TYPE("activity_put_type", "活动投放方式-大类 1:测试 2:算法 3:灰度测试 4:手投"),

    ACTIVITY_RELEASE_MODE("activity_release_mode", "活动投放模式 1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层"),

    ACTIVITY_RELEASE_SUB_MODE("activity_release_sub_mode", "广告位上直投活动的投放方式 仅投1 优投人工2 优投算法3 纯算法4 其他0"),

    RELEASE_CONTENT_TYPE("release_content_type", "广告位投放内容类型 1:活动、2：直投页、3：自定义活动"),

    PLUGIN_PUT_TYPE("plugin_put_type", "插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0"),

    FLOW_TYPE("flow_type", "流量类型 1:sdk 2:adx 3:其它"),

    RISK_TYPE("risk_type", "风控类型 0：正常，1：用户作弊，2：广告位作弊"),

    GROUP_ID("group_id", "ADX推广组id"),

    RESOURCE_ID("resource_id", "ADX资源位id"),

    IDEA_ID("idea_id", "ADX创意id"),

    //ADX创意素材id
    IDEA_MATERIAL_ID("idea_material_id",  "ADX创意素材id"),

    //ADX创意素材类型 1-单图  2-双图 3-三图
    IDEA_MATERIAL_TYPE("idea_material_type", "ADX创意素材类型"),

    ADX_PUT_TYPE("adx_put_type", "adx投放方式 0依次 1按比例 2按算法"),

    SDK_REPORT_TYPE("sdk_report_type", "sdk上报类型 1-SDK启动上报，2-SDK崩溃上报"),

    SDK_VERSION("sdk_version", "sdk版本"),

    DOWNLOAD_STATUS("download_status", "SDK下载状态 1-SDK下载成功 2-SDK下载失败"),

    PATCH_VERSION("patch_version", "补丁版本号"),

    PATCH_TYPE("patch_type", "补丁状态 1-补丁下载 2-补丁生效"),

    DSM2_A("dsm2_a", "资源位类型 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截"),

    FEE("fee", "广告消耗，单位分"),

    WITH_ENC_VEDIO("with_enc_vedio", "活动皮肤是否出激励视频 1-出 0-不出"),

    SLOT_DOCKING_TYPE("slot_docking_type", "媒体广告位对接方式 1:sdk  2:api"),

    BACKEND_EFFECT_TYPE("backend_effect_type", "后端转化类型 (1:安装 2:启动 3:注册 4:激活 5:登录 6:付费 7:进件 8:完件 9:签收 10:拒签)"),

    ADVERT_PLAN_ID("advert_plan_id", "广告推广计划id"),

    JS_ADVERT("js_advert", "1:带有js落地页的广告"),

    BAIQI_ADVERT("baiqi_advert", "1:百奇广告"),

    GOODS_ID("goods_id", "百奇商品id"),

    MERCHANT_ID("merchant_id", "百奇商家id"),

    URL_MD5("url_md5", "落地页链接md5值"),

    BACK_MATCH_TYPE("back_match_type", "后端回传匹配类型 1-订单匹配 2-设备号匹配 3-ip+ua匹配"),

    SLOT_ACTIVITY_TYPE("slot_activity_type", "活动投放类型 1-配置包插件活动,2-活动工具,3-直投页,4-展示广告,5-浮标,6-增值广告,7-活动直投落地页,8-激励视屏,9-新激励视屏,10-增值,11-dp广告"),

    UA("ua", "设备ua（IOS,Android,unknow）"),

    LAUNCH_SCENE("launch_scene", "发券场景"),

    ADX_APP_ID("adx_app_id", "adx联盟流量媒体id"),

    APP_FLOW_TYPE("app_flow_type","媒体流量类型 1-微信,2-QQ,3-支付宝,4-其他");


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaInnerLogDetailMonthEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
