package cn.com.duiba.bigdata.common.biz.entity.redis;

import lombok.Data;

import java.util.Map;

/**
 * bigdata_redis 对应的指标集
 * @author xugf
 * @date 2019-09-08
 */
@Data
public class BigdataRedisMetricsEntity {
    //活动请求
    private Long activityRequest;

    //活动参与
    private Long activityJoin;

    //落地页曝光
    private Long landpageExposure;

    //落地页转化
    private Long landpageClick;

    //发券量
    private Long launch;

    //广告券计费点击
    private Long effectClick;

    //计费金额(消耗)
    private Long fee;

    //底价消耗
    private Long minFee;

    //广告普通点击
    private Long click;

    //广告曝光
    private Long advertExposure;

    //SDK广告位曝光
    private Long sdkSlotExposure;

    //SDK广告位点击
    private Long sdkSlotClick;

    //API广告位曝光
    private Long apiSlotExposure;

    //API广告位点击
    private Long apiSlotClick;

    //哪吒发券量
    private Long nezhaLaunch;

    //预估ctr总和
    private Double preCtr;

    //预估cvr总和
    private Double preCvr;

    //统计ctr总和
    private Double statCtr;

    //统计cvr总和
    private Double statCvr;

    //adx消耗
    private Long adxFee;

    //adx点击
    private Long adxClick;

    //adx曝光
    private Long adxExposure;

    //adx参与竞价数
    private Long adxBid;

    //adx竞价成功数
    private Long adxBidSuccess;

    //后端转化指标
    private Map<String, Long> backendCntMap;

    //广告后端转化（总量）
    private Long backendClick;

    //维稳因子
    private Double factor ;

}
