package cn.com.duiba.bigdata.common.biz.enums.tables.bigdata;

/**
 * @author xugf 2020-11-27
 * hologres表的所有字段说明，枚举字段需要与 HologresDimensionEnum 中的枚举字段相同
 */
public enum DuibaAccessLogDetailMonthEnum {

    DATE_PARTITION("date_partition", "按天分区，格式：yyyyMMdd"),

    LOG_UUID("log_uuid", "唯一键"),

    UNIX_TIME("unix_time", "unix时间戳"),

    CONSUMER_ID("consumer_id", "用户id"),

    URL_HOST("url_host", "域名"),

    URL_PATH("url_path", "接口方法，已全部转换成小写"),

    HTTP_METHOD("http_method", "http方法类型，GET/POST"),

    TENTER("tenter", "广告位参数，SOW：来自广告位首次访问"),

    APP_ID("app_id", "媒体id"),

    SLOT_ID("slot_id", "广告位id"),

    ACTIVITY_ID("activity_id", "活动id"),

    APP_SOURCE("app_source", "创建App的来源  0：积分商城（兑吧） 1：广告平台（推啊）"),

    APP_LEVEL("app_level", "媒体性质 1-在线KA,2-潜力KA,3-普通媒体"),

    APP_TYPE("app_type", "媒体类型 1-在线ka 2-普通媒体 3-rtb-adx 4-rtb-非adx"),

    DEVELOPER_ID("developer_id", "媒体账号id"),

    APP_FIRST_TRADE_ID("app_first_trade_id", "媒体一级行业"),

    APP_SECOND_TRADE_ID("app_second_trade_id", "媒体二级行业"),

    APP_FLOW_TAG("app_flow_tag", "媒体流量标签"),

    SLOT_MATERIAL_ID("slot_material_id", "广告位素材id"),

    SLOT_MATERIAL_PUT_TYPE("slot_material_put_type", "广告位素材投放方式 0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级"),

    ACTIVITY_SOURCE("activity_source", "活动来源 0-兑吧 1-推啊"),

    ACTIVITY_TYPE("activity_type", "广告位投放活动类型 1-常规活动，2-自定义活动（非深度），3-直投页，4-深度互动，5-原生互动，6-激励互动"),

    ACTIVITY_PUT_TYPE("activity_put_type", "活动投放方式-大类 1:测试 2:算法 3:灰度测试 4:手投"),

    ACTIVITY_RELEASE_MODE("activity_release_mode", "活动投放模式 1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层"),

    ACTIVITY_RELEASE_SUB_MODE("activity_release_sub_mode", "广告位上直投活动的投放方式 仅投1 优投人工2 优投算法3 纯算法4 其他0"),

    RELEASE_CONTENT_TYPE("release_content_type", "广告位投放内容类型 1:活动、2：直投页、3：自定义活动"),

    ACTIVITY_STAGE("activity_stage", "活动阶段 1：广告位访问 2：活动访问 3：活动参与"),

    PLUGIN_PUT_TYPE("plugin_put_type", "插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0"),

    FLOW_TYPE("flow_type", "流量类型 1:sdk 2:adx 3:其它"),

    GROUP_ID("group_id", "ADX推广组id"),

    RESOURCE_ID("resource_id", "ADX资源位id"),

    IDEA_ID("idea_id", "ADX创意id"),

    //ADX创意素材id
    IDEA_MATERIAL_ID("idea_material_id",  "ADX创意素材id"),

    //ADX创意素材类型 1-单图  2-双图 3-三图
    IDEA_MATERIAL_TYPE("idea_material_type", "ADX创意素材类型"),

    ADX_PUT_TYPE("adx_put_type", "adx投放方式 0依次 1按比例 2按算法"),

    DPM_B("dpm_b", "埋点"),

    DSM2_A("dsm2_a", "资源位类型 1-广告位直投,2-浮标,3-推荐弹层,4-一次返回拦截,5-谢谢参与推荐弹层 7-二次返回拦截 9-三次返回拦截"),

    ENC_VIDEO_MODULE_TYPE("enc_video_module_type", "激励视频埋点类型 1 弹窗曝光  2 视频按钮点击 3 视频弹窗关"),

    WITH_ENC_VEDIO("with_enc_vedio", "活动皮肤是否出激励视频 1-出 0-不出"),

    SLOT_DOCKING_TYPE("slot_docking_type", "媒体广告位对接方式 1:sdk  2:api"),

    COMPLAIN_SOURCE("complain_source", "百奇客诉来源 1-奖品页,2-订单详情页,3-活动首页,4-公众号,5-短信"),

    ADX_APP_ID("adx_app_id", "adx联盟流量媒体id")


    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //字段备注
    private final String desc;

    DuibaAccessLogDetailMonthEnum(String tableFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDesc() {
        return desc;
    }
}
