package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.dto.HologresResultDto;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

/**
 * @author Created by Chimomo
 */
public class ReflectionUtil {
    private ReflectionUtil() {
        throw new AssertionError();
    }

    /**
     * 通过反射取对象指定字段(属性)的值
     *
     * @param target    目标对象
     * @param fieldName 字段的名字
     * @return 字段的值
     */
    public static Object getValue(Object target, String fieldName) {
        try {
            Class<?> clazz = target.getClass();
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(target);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 通过反射给对象的指定字段赋值
     *
     * @param target    目标对象
     * @param fieldName 字段的名称
     * @param value     值
     */
    public static void setValue(Object target, String fieldName, Object value) {
        try {
            Class<?> clazz = target.getClass();
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(target, value);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 通过反射获取字段的类型
     *
     * @param target    目标对象
     * @param fieldName 字段的名称
     * @return 字段类型
     */
    public static Class<?> getType(Object target, String fieldName) {
        try {
            Class<?> clazz = target.getClass();
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.getType();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}