package cn.com.duiba.bigdata.common.biz.utils;

import org.apache.commons.lang3.StringUtils;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateFormatUtil {

    public static Date parse(String pattern, String strDate)
            throws ParseException {
        SimpleDateFormat lsdf = getSdf();
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.parse(strDate);
    }

    public static long getTime(String strDate) throws Exception {
        Date dt = parse("yyyy-MM-dd HH:mm:ss", strDate);
        return dt.getTime();
    }

    public static Date parse(Locale locale, String pattern, String strDate)
            throws ParseException {
        SimpleDateFormat lsdf = getLocaleSdf();
        lsdf.setDateFormatSymbols(DateFormatSymbols.getInstance(locale));
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.parse(strDate);
    }

    public static String format(String pattern, Date date) {
        SimpleDateFormat lsdf = getSdf();
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.format(date);
    }

    public static String timestamp2Date(String seconds, String format) {
        String time = "";
        if (StringUtils.isNotBlank(seconds) && StringUtils.isNotBlank(format)) {
            SimpleDateFormat lsdf = new SimpleDateFormat(format, Locale.US);
            time = lsdf.format(new Date(Long.valueOf(seconds + "000")));
        }
        return time;
    }

    public static String format(String pattern, String strDate) throws Exception {
        return format(pattern, parse("yyyy-MM-dd HH:mm:ss", strDate));
    }

    public static String format(Locale locale, String pattern, Date date) {
        SimpleDateFormat lsdf = getLocaleSdf();
        lsdf.setDateFormatSymbols(DateFormatSymbols.getInstance(locale));
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.format(date);
    }

    public static String convertFromTo(String srcPattern, String dstPattern,
                                       String strDate) throws ParseException {
        SimpleDateFormat lsdf = getSdf();
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(srcPattern);
        Date date = lsdf.parse(strDate);
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(dstPattern);
        return lsdf.format(date);
    }

    private DateFormatUtil() {
        throw new UnsupportedOperationException();
    }

    private static ThreadLocal<SimpleDateFormat> sdf = new ThreadLocal<SimpleDateFormat>();

    private static SimpleDateFormat getSdf() {
        SimpleDateFormat lsdf = sdf.get();
        if (lsdf != null) {
            return lsdf;
        }
        lsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        sdf.set(lsdf);
        return lsdf;
    }

    private static ThreadLocal<SimpleDateFormat> localeSdf = new ThreadLocal<SimpleDateFormat>();

    private static SimpleDateFormat getLocaleSdf() {
        SimpleDateFormat lsdf = localeSdf.get();
        if (lsdf != null) {
            return lsdf;
        }
        lsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        localeSdf.set(lsdf);
        return lsdf;
    }

    private static final TimeZone timezone = TimeZone.getDefault();

    //获取和当前的时间差 秒
    public static Long getNowDifferenceTime(String logTime, String pattern) throws ParseException {
        if (StringUtils.isBlank(logTime)) {
            return 0L;
        }
        return (System.currentTimeMillis() - parse(pattern, logTime).getTime()) / 1000;
    }

}
