package cn.com.duiba.bigdata.common.biz.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;

import java.io.InputStream;

/**
 * 阿里云oss 工具类，简化开发接入
 */
public class AliOssUtil {
    //oss客户端
    private OSS ossClient = null;

    //填写Bucket所在地域对应的Endpoint
    private String endpoint;

    //阿里云ram账号秘钥
    private String accessKeyId;
    private String accessKeySecret;

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    /**
     * 获取oss客户端
     *
     * @return oss客户端
     */
    protected OSS getOssClient() {
        if (ossClient != null) {
            return ossClient;
        }

        return initOssClient();
    }

    /**
     * 初始化oss连接
     *
     * @return oss客户端
     */
    private synchronized OSS initOssClient() {
        if (ossClient != null) {
            return ossClient;
        }

        ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        return ossClient;
    }

    /**
     * 关闭oss连接
     */
    public void close() {
        ossClient.shutdown();
    }

    /**
     * 上传数据到oss中，如果文件已经存在，会覆盖写
     *
     * @param bucketName bucket名称
     * @param objectName 文件所在的路径
     * @param input      io流
     */
    public void putObject(String bucketName, String objectName, InputStream input) {
        getOssClient().putObject(bucketName, objectName, input);
    }

    /**
     * 获取文件流（注意点：数据读取完成后，获取的流必须关闭，否则会造成连接泄漏，导致请求无连接可用）
     *
     * @param bucketName bucket名称
     * @param objectName 文件所在的路径
     * @return io流
     */
    public InputStream getObjectContentInputStream(String bucketName, String objectName) {
        OSSObject ossObject = ossClient.getObject(bucketName, objectName);

        // 调用ossObject.getObjectContent获取文件输入流，可读取此输入流获取其内容。
        return ossObject.getObjectContent();
    }

}
