package cn.com.duiba.bigdata.common.biz.enums;

import java.util.HashMap;
import java.util.Map;

public enum DimStatisticsIndexEnum {
    INSTANCE;

    private Map<String, Integer> dimIndexMap;

    private DimStatisticsIndexEnum() {
        dimIndexMap = new HashMap<>();

        //填写维度名称和对应的顺序
        //广告
        dimIndexMap.put("advert", 1);
        //广告配置
        dimIndexMap.put("package", 2);
        //媒体
        dimIndexMap.put("app", 3);
        //广告位
        dimIndexMap.put("slot", 4);
        //广告发券次数
        dimIndexMap.put("launch_times", 5);
        //活动
        dimIndexMap.put("activity", 6);
        //素材
        dimIndexMap.put("material", 7);
        //广告类型
        dimIndexMap.put("main_type", 8);
        //流量来源
        dimIndexMap.put("flow_type", 9);
        //广告二级标签
        dimIndexMap.put("second_tag", 10);
        //广告计费方式
        dimIndexMap.put("charge_type", 11);
        //托管广告转化成本
        dimIndexMap.put("trusteeship_cost", 12);
        //渠道类型
        dimIndexMap.put("source_type", 13);
        //广告位素材
        dimIndexMap.put("slot_material", 14);
        //出价区间 1：0-5 2：5-10 3：10-15
        dimIndexMap.put("fee_level", 15);
        //算法推荐类型
        dimIndexMap.put("alg_type", 16);
        //是否是表单类广告 0:非表单 1:表单
        dimIndexMap.put("form_advert", 17);
        //adx资源位
        dimIndexMap.put("resource", 18);
        //adx创意
        dimIndexMap.put("idea", 19);
        //adx出价策略
        dimIndexMap.put("adx_strategy", 20);
        //adx出价区间
        dimIndexMap.put("adx_level", 21);
        //媒体行业
        dimIndexMap.put("app_trade", 22);
        //广告行业
        dimIndexMap.put("advert_trade", 23);
        //排序分
        dimIndexMap.put("rank_score", 24);
        //目标转化类型
        dimIndexMap.put("target_type", 25);
        //MDP托管自动人群
        dimIndexMap.put("dmp_tag", 26);
        //资源位类型
        dimIndexMap.put("resource_type", 27);
        //插件ID
        dimIndexMap.put("plugin", 28);
        //插件次序
        dimIndexMap.put("plugin_index", 29);
        //活动投放方式
        dimIndexMap.put("activity_put_type", 30);
        //广告位素材算法版本
        dimIndexMap.put("material_alg_type", 31);
        //adx出价类型
        dimIndexMap.put("adx_price_type", 32);
        //活动推荐算法版本
        dimIndexMap.put("activity_alg_type", 33);


    }

    public Integer getDimIndex(String dim) {
        return dimIndexMap.get(dim);
    }
}
