/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.alibaba.fastjson.JSONObject;
import java.net.InetAddress;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsUtil {
    private static final Logger logger = LoggerFactory.getLogger(EsUtil.class);
    private TransportClient client;
    private String esClusterName;
    private String esHost;
    private String esUserName;
    private String esPwd;

    private EsUtil() throws Exception {
        this.initClient();
    }

    public EsUtil(String esClusterName, String esHost, String esUserName, String esPwd) throws Exception {
        this.esClusterName = esClusterName;
        this.esHost = esHost;
        this.esUserName = esUserName;
        this.esPwd = esPwd;
        this.initClient();
    }

    private synchronized void initClient() throws Exception {
        if (this.client != null) {
            return;
        }
        this.client = new PreBuiltXPackTransportClient(Settings.builder().put("cluster.name", this.esClusterName).put("xpack.security.user", String.format("%s:%s", this.esUserName, this.esPwd)).put("client.transport.sniff", false).build(), new Class[0]).addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(this.esHost), 9300));
    }

    public void close() {
        this.client.close();
        this.client = null;
    }

    public void batchUpsert(String index, Map<String, Map<String, JSONObject>> batchMap) {
        for (String type : batchMap.keySet()) {
            Map<String, JSONObject> data = batchMap.get(type);
            this.batchUpsert(index, type, data);
        }
    }

    public void batchInsert(String index, Map<String, Map<String, JSONObject>> batchMap) {
        for (String type : batchMap.keySet()) {
            Map<String, JSONObject> data = batchMap.get(type);
            this.batchInsert(index, type, data);
        }
    }

    public void batchUpsert(String index, String type, Map<String, JSONObject> batchMap) {
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (String key : batchMap.keySet()) {
            JSONObject source = batchMap.get(key);
            UpdateRequestBuilder urb = this.getUpdateRequestBuilder(index, type, key, (Map)source);
            bulkRequest.add(urb);
        }
        this.executeRequest(bulkRequest);
    }

    public void batchInsert(String index, String type, Map<String, JSONObject> batchMap) {
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (String key : batchMap.keySet()) {
            JSONObject source = batchMap.get(key);
            IndexRequestBuilder irb = this.getIndexRequestBuilder(index, type, key, (Map)source);
            bulkRequest.add(irb);
        }
        this.executeRequest(bulkRequest);
    }

    private void executeRequest(BulkRequestBuilder bulkRequest) {
        if (bulkRequest == null || bulkRequest.numberOfActions() == 0) {
            return;
        }
        bulkRequest.execute();
    }

    private UpdateRequestBuilder getUpdateRequestBuilder(String index, String type, String key, Map source) {
        UpdateRequestBuilder urb = this.client.prepareUpdate(index, type, key);
        urb.setDoc(source);
        urb.setDocAsUpsert(true);
        urb.setRetryOnConflict(3);
        return urb;
    }

    private IndexRequestBuilder getIndexRequestBuilder(String index, String type, String key, Map source) {
        return this.client.prepareIndex(index, type, key).setSource(source);
    }
}

