/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.utils.HbaseUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseDataUtil {
    private static final Logger logger = LoggerFactory.getLogger(HbaseDataUtil.class);
    private HbaseUtil hbaseUtil;
    private String DEFAULT_NAMESPACE = "default";
    private String DEFAULT_COLUMN_FAMILY = "cf";

    public void setHbaseUtil(HbaseUtil hbaseUtil) {
        this.hbaseUtil = hbaseUtil;
    }

    public HbaseUtil getHbaseUtil() {
        return this.hbaseUtil;
    }

    private String getLowerCamelColumn(boolean lowerCamel, String column) {
        if (lowerCamel && column.contains("_")) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, column);
        }
        return column;
    }

    private void putMapData(Map<String, String> map, String column, String value, boolean lowerCamel) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{column, value})) {
            return;
        }
        column = this.getLowerCamelColumn(lowerCamel, column);
        map.put(column, value);
    }

    private void putMapData(Map<String, Map<String, String>> map, String rowKey, Map<String, String> columnMap) {
        if (StringUtils.isBlank((CharSequence)rowKey)) {
            return;
        }
        if (columnMap == null || columnMap.size() == 0) {
            return;
        }
        map.put(rowKey, columnMap);
    }

    private String getResultString(Result result, String family, String column) {
        String value = "";
        if (result != null && result.containsColumn(family.getBytes(), column.getBytes())) {
            value = Bytes.toString((byte[])result.getValue(family.getBytes(), column.getBytes()));
        }
        return value;
    }

    private Map<String, String> getResultMap(Result result, String family, List<String> columns, boolean lowerCamel) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String column : columns) {
            String value = this.getResultString(result, family, column);
            this.putMapData(map, column, value, lowerCamel);
        }
        return map;
    }

    private <T> T getResultMap(Result result, String family, List<String> columns, Class<T> clazz) {
        Map<String, String> map = this.getResultMap(result, family, columns, true);
        return (T)JSON.parseObject((String)JSON.toJSONString(map), clazz);
    }

    private Map<String, String> getResultMap(Result result, String family, boolean lowerCamel) {
        List cellList = result.listCells();
        if (CollectionUtils.isEmpty((Collection)cellList)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Cell cell : cellList) {
            if (!Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell)).equalsIgnoreCase(family)) continue;
            String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
            String value = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
            this.putMapData(map, column, value, lowerCamel);
        }
        return map;
    }

    private <T> T getResultMap(Result result, String family, Class<T> clazz) {
        Map<String, String> map = this.getResultMap(result, family, true);
        return (T)JSON.parseObject((String)JSON.toJSONString(map), clazz);
    }

    private Map<String, String> getResultMap(Result[] results, String family, String column) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            String value = this.getResultString(result, family, column);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            map.put(rowKey, value);
        }
        return map;
    }

    private Map<String, Map<String, String>> getResultMap(Result[] results, String family, List<String> columns, boolean lowerCamel) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            Map<String, String> columnMap = this.getResultMap(result, family, columns, lowerCamel);
            this.putMapData(map, rowKey, columnMap);
        }
        return map;
    }

    private <T> Map<String, T> getResultMap(Result[] results, String family, List<String> columns, Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            T obj = this.getResultMap(result, family, columns, clazz);
            if (obj == null) continue;
            map.put(rowKey, obj);
        }
        return map;
    }

    private Map<String, Map<String, String>> getResultMap(Result[] results, String family, Map<String, List<String>> rowkeyMap, boolean lowerCamel) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            Map<String, String> columnMap = this.getResultMap(result, family, rowkeyMap.get(rowKey), lowerCamel);
            this.putMapData(map, rowKey, columnMap);
        }
        return map;
    }

    private <T> Map<String, T> getResultMap(Result[] results, String family, Map<String, List<String>> rowkeyMap, Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (Result result : results) {
            String rowKey;
            T obj;
            if (result == null || result.isEmpty() || (obj = this.getResultMap(result, family, rowkeyMap.get(rowKey = Bytes.toString((byte[])result.getRow())), clazz)) == null) continue;
            map.put(rowKey, obj);
        }
        return map;
    }

    private Map<String, Map<String, String>> getResultMap(Result[] results, String family, boolean lowerCamel) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            Map<String, String> columnMap = this.getResultMap(result, family, lowerCamel);
            this.putMapData(map, rowKey, columnMap);
        }
        return map;
    }

    private <T> Map<String, T> getResultMap(Result[] results, String family, Class<T> clazz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            String rowKey = Bytes.toString((byte[])result.getRow());
            T obj = this.getResultMap(result, family, clazz);
            if (obj == null) continue;
            map.put(rowKey, obj);
        }
        return map;
    }

    public Boolean exists(String tableName, String rowKey) {
        return this.exists(this.DEFAULT_NAMESPACE, tableName, rowKey);
    }

    public Boolean exists(String nameSpace, String tableName, String rowKey) {
        return this.hbaseUtil.exists(nameSpace, tableName, rowKey);
    }

    public String getRow(String tableName, String rowKey, String column) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public String getRow(String nameSpace, String tableName, String rowKey, String family, String column) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family, column);
        return this.getResultString(result, family, column);
    }

    public Map<String, String> getRow(String tableName, String rowKey, List<String> columns) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns, false);
    }

    public Map<String, String> getRow(String tableName, String rowKey, List<String> columns, boolean lowerCamel) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns, lowerCamel);
    }

    public <T> T getRow(String tableName, String rowKey, List<String> columns, Class<T> clazz) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns, clazz);
    }

    public Map<String, String> getRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns, boolean lowerCamel) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family, columns);
        return this.getResultMap(result, family, columns, lowerCamel);
    }

    public <T> T getRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns, Class<T> clazz) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family, columns);
        return this.getResultMap(result, family, columns, clazz);
    }

    public Map<String, String> getRow(String tableName, String rowKey) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, false);
    }

    public Map<String, String> getRow(String tableName, String rowKey, boolean lowerCamel) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, lowerCamel);
    }

    public <T> T getRow(String tableName, String rowKey, Class<T> clazz) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, clazz);
    }

    public Map<String, String> getRow(String nameSpace, String tableName, String rowKey, String family, boolean lowerCamel) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family);
        return this.getResultMap(result, family, lowerCamel);
    }

    public <T> T getRow(String nameSpace, String tableName, String rowKey, String family, Class<T> clazz) {
        Result result = this.hbaseUtil.getRow(nameSpace, tableName, rowKey, family);
        return this.getResultMap(result, family, clazz);
    }

    public Map<String, String> getRowList(String tableName, List<String> rowKeyList, String column) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public Map<String, String> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, String column) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family, column);
        return this.getResultMap(results, family, column);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList, List<String> columns) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, columns, false);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList, List<String> columns, boolean lowerCamel) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, columns, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String tableName, List<String> rowKeyList, List<String> columns, Class<T> clazz) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, columns, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, List<String> columns, boolean lowerCamel) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family, columns);
        return this.getResultMap(results, family, columns, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, List<String> columns, Class<T> clazz) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family, columns);
        return this.getResultMap(results, family, columns, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, false);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, List<String> rowKeyList, boolean lowerCamel) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String tableName, List<String> rowKeyList, Class<T> clazz) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, boolean lowerCamel) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family);
        return this.getResultMap(results, family, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, Class<T> clazz) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyList, family);
        return this.getResultMap(results, family, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, Map<String, List<String>> rowKeyMap) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY, false);
    }

    public Map<String, Map<String, String>> getRowList(String tableName, Map<String, List<String>> rowKeyMap, boolean lowerCamel) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String tableName, Map<String, List<String>> rowKeyMap, Class<T> clazz) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY, clazz);
    }

    public Map<String, Map<String, String>> getRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family, boolean lowerCamel) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyMap, family);
        return this.getResultMap(results, family, rowKeyMap, lowerCamel);
    }

    public <T> Map<String, T> getRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family, Class<T> clazz) {
        Result[] results = this.hbaseUtil.getRowList(nameSpace, tableName, rowKeyMap, family);
        return this.getResultMap(results, family, rowKeyMap, clazz);
    }

    public boolean insert(String tableName, String rowKey, String column, String value) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column, value);
    }

    public boolean insert(String nameSpace, String tableName, String rowKey, String family, String column, String value) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowKey, family, column, value);
    }

    public boolean insert(String tableName, String rowKey, Map<String, String> columns) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    public boolean insert(String nameSpace, String tableName, String rowKey, String family, Map<String, String> columns) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowKey, family, columns);
    }

    public boolean insert(String tableName, List<String> rowkeyList, String column, String value) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY, column, value);
    }

    public boolean insert(String nameSpace, String tableName, List<String> rowkeyList, String family, String column, String value) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowkeyList, family, column, value);
    }

    public boolean insert(String tableName, Map<String, Map<String, String>> rowKeyMap) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean insert(String nameSpace, String tableName, Map<String, Map<String, String>> rowKeyMap, String family) {
        return this.hbaseUtil.insert(nameSpace, tableName, rowKeyMap, family);
    }

    public boolean deleteRow(String tableName, String rowKey, String column) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family, String column) {
        return this.hbaseUtil.deleteRow(nameSpace, tableName, rowKey, family, column);
    }

    public boolean deleteRow(String tableName, String rowKey, List<String> columns) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns) {
        return this.hbaseUtil.deleteRow(nameSpace, tableName, rowKey, family, columns);
    }

    public boolean deleteRow(String tableName, String rowKey) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family) {
        return this.hbaseUtil.deleteRow(nameSpace, tableName, rowKey, family);
    }

    public boolean deleteRowList(String tableName, List<String> rowkeyList, String column) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY, column);
    }

    public boolean deleteRowList(String nameSpace, String tableName, List<String> rowkeyList, String family, String column) {
        return this.hbaseUtil.deleteRowList(nameSpace, tableName, rowkeyList, family, column);
    }

    public boolean deleteRowList(String tableName, Map<String, List<String>> rowKeyMap) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean deleteRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family) {
        return this.hbaseUtil.deleteRowList(nameSpace, tableName, rowKeyMap, family);
    }

    public boolean deleteRowList(String tableName, List<String> rowkeyList) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY);
    }

    public boolean deleteRowList(String nameSpace, String tableName, List<String> rowkeyList, String family) {
        return this.hbaseUtil.deleteRowList(nameSpace, tableName, rowkeyList, family);
    }
}

