/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.entity.redis.KeyIndex;
import cn.com.duiba.bigdata.common.biz.enums.DimStatisticsIndexEnum;
import cn.com.duiba.bigdata.common.biz.utils.DateFormatUtil;
import cn.com.duiba.bigdata.common.biz.utils.MD5Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigdataUtil {
    private static final Logger log = LoggerFactory.getLogger(BigdataUtil.class);

    public static boolean numberCheck(String str) {
        return !StringUtils.isBlank((CharSequence)str) && str.matches("[0-9]*");
    }

    public static List<String> getTimeKeyList(String key, List<String> timeList) {
        ArrayList<String> keyList = new ArrayList<String>();
        for (String time : timeList) {
            keyList.add(key + time);
        }
        return keyList;
    }

    public static JSONObject parseJson(Object content) {
        JSONObject jsonObject = null;
        if (content == null) {
            return null;
        }
        if (content instanceof String) {
            String json = (String)content;
            jsonObject = JSON.parseObject((String)json);
        } else if (content instanceof JSONObject) {
            jsonObject = (JSONObject)content;
        }
        return jsonObject;
    }

    public static String getString(JSONObject object, String key) {
        if (object == null) {
            return null;
        }
        String str = object.getString(key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        if ("null".equalsIgnoreCase(str)) {
            return null;
        }
        return str;
    }

    public static String getMD5HbaseRowkey(Object ... obj) {
        String key = BigdataUtil.getJoinStr(obj);
        return StringUtils.isBlank((CharSequence)key) ? null : MD5Util.computeMD5(key).substring(0, 4) + "-" + key;
    }

    public static String getJoinStr(Object ... obj) {
        return BigdataUtil.getSepJoinStr("_", obj);
    }

    public static String getSepJoinStr(String sep, Object ... obj) {
        if (obj.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object str : obj) {
            sb.append(str).append(sep);
        }
        return sb.delete(sb.length() - sep.length(), sb.length()).toString();
    }

    public static String getStr(String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static void mergeRowKeyMap(Map<String, String> map, Map<String, Map<String, Long>> rowkeyColumnMap) {
        for (String rowkey : map.keySet()) {
            JSONObject newJson = JSON.parseObject((String)map.get(rowkey));
            if (rowkeyColumnMap.containsKey(rowkey)) {
                Map<String, Long> oldColumnMap = rowkeyColumnMap.get(rowkey);
                BigdataUtil.mergeMap(newJson, oldColumnMap);
                continue;
            }
            HashMap<String, Long> newColumnMap = new HashMap<String, Long>();
            for (String key : newJson.keySet()) {
                Long value = newJson.getLongValue(key);
                newColumnMap.put(key, value);
            }
            rowkeyColumnMap.put(rowkey, newColumnMap);
        }
    }

    private static void mergeMap(JSONObject newJson, Map<String, Long> oldColumnMap) {
        for (String key : newJson.keySet()) {
            Long value = newJson.getLongValue(key);
            if (oldColumnMap.containsKey(key)) {
                oldColumnMap.put(key, oldColumnMap.get(key) + value);
                continue;
            }
            oldColumnMap.put(key, value);
        }
    }

    public static List<String> getTimeList(String type, String pattern, int number, Date date) {
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < number; ++i) {
            calendar.setTime(date);
            if ("day".equals(type)) {
                calendar.add(5, -i);
            } else if ("hour".equals(type)) {
                calendar.add(11, -i);
            } else if ("minute".equals(type)) {
                calendar.add(12, -i);
            }
            list.add(DateFormatUtil.format(pattern, calendar.getTime()));
        }
        return list;
    }

    public static List<String> getTimeList(String pattern, int before) {
        DateTime dateTime = new DateTime();
        ArrayList<String> timeList = new ArrayList<String>();
        for (int i = 0; i < before; ++i) {
            if ("yyyyMMdd".equals(pattern)) {
                timeList.add(dateTime.plusDays(-i).toString(pattern));
                continue;
            }
            if ("yyyyMMddHH".equals(pattern)) {
                timeList.add(dateTime.plusHours(-i).toString(pattern));
                continue;
            }
            if (!"yyyyMMddHHmm".equals(pattern)) continue;
            timeList.add(dateTime.plusMinutes(-i).toString(pattern));
        }
        return timeList;
    }

    public static String[] getTimeArray(int before, String pattern) {
        DateTime dateTime = new DateTime();
        String[] times = new String[before];
        for (int i = 1; i <= before; ++i) {
            times[i - 1] = dateTime.plusMinutes(-i).toString(pattern);
        }
        return times;
    }

    public static <T> Map<String, Long> getBackendCntMap(Map<String, T> data) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            for (String key : data.keySet()) {
                if (!BigdataUtil.numberCheck(key)) continue;
                map.put(key, Long.valueOf(data.get(key).toString()));
            }
        }
        catch (NumberFormatException e) {
            log.error("get backend data error", (Throwable)e);
        }
        return map;
    }

    public static <T extends Number> String division(T dividend, T divisor, int digit) {
        String result = "0";
        try {
            if (dividend != null && divisor != null) {
                double divisorDouble = divisor.doubleValue();
                double dividendDouble = dividend.doubleValue();
                if (divisorDouble != 0.0) {
                    result = new BigDecimal(dividendDouble / divisorDouble).setScale(digit, 4).stripTrailingZeros().toPlainString();
                }
            }
        }
        catch (Exception e) {
            log.error("division error", (Throwable)e);
        }
        return result;
    }

    public static String getBigdataRedisKey(String prefix, String suffix, Object ... array) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            log.error("GetRedisKeyUDF prefix is null");
            return null;
        }
        if (array == null || array.length == 0) {
            return prefix + "_" + suffix;
        }
        if (array.length % 2 != 0) {
            log.error("GetRedisKeyUDF eval, array.length % 2 != 0");
            return null;
        }
        ArrayList<KeyIndex> list = new ArrayList<KeyIndex>();
        for (int i = 0; i < array.length; i += 2) {
            String key = null;
            String value = null;
            if (array[i] != null) {
                key = array[i].toString();
            }
            if (array[i + 1] != null) {
                value = array[i + 1].toString();
            }
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
                return null;
            }
            Integer index = DimStatisticsIndexEnum.INSTANCE.getDimIndex(key);
            if (index == null) {
                log.error("key = {} is error, please check it.", (Object)key);
                return null;
            }
            KeyIndex keyIndex = new KeyIndex(key, value, index);
            list.add(keyIndex);
        }
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        sb.append(prefix.toUpperCase()).append("_");
        for (KeyIndex info : list) {
            sb.append(info.getValue()).append("_");
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static void putHbaseColumnData(Map<String, String> map, String column, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            map.put(column, value);
        }
    }

    public static String parseUrlParam(String str, String key) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if (!str.startsWith(key)) {
                key = "&" + key;
            }
            if (str.contains(key)) {
                return str.substring(0, (str = str.substring(str.indexOf(key) + key.length())).contains("&") ? str.indexOf("&") : str.length());
            }
        }
        return null;
    }

    public static <T extends Number> Double avg(List<T> set, boolean skip) {
        int i = 0;
        double result = 0.0;
        for (Number num : set) {
            if (num == null) continue;
            double value = num.doubleValue();
            if (skip && value == 0.0) continue;
            ++i;
            result += value;
        }
        if (i != 0) {
            return result / (double)i;
        }
        return 0.0;
    }

    public static Map<String, Long> mergeData(List<String> keyList, Map<String, Map<String, String>> dataMap) {
        HashMap<String, Long> mergeMap = new HashMap<String, Long>();
        for (String key : keyList) {
            Map<String, String> data = dataMap.get(key);
            for (String field : data.keySet()) {
                mergeMap.put(field, mergeMap.getOrDefault(field, 0L) + Long.valueOf(data.get(field)));
            }
        }
        return mergeMap;
    }

    public static <X, Y> Map<X, Y> mergeResultMap(Map<X, Y> ... resultMap) {
        if (resultMap == null || resultMap.length == 0) {
            return null;
        }
        HashMap<X, Y> dataMap = new HashMap<X, Y>();
        for (Map<X, Y> map : resultMap) {
            dataMap.putAll(map);
        }
        return dataMap;
    }

    public static String getHbaseJoinStr(Object ... obj) {
        return BigdataUtil.getSepJoinStr("-", obj);
    }
}

