/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(HbaseUtil.class);
    private Connection connection = null;
    private String zkList;
    private String username;
    private String password;
    private String DEFAULT_NAMESPACE = "default";
    private String DEFAULT_COLUMN_FAMILY = "cf";
    private static final int saveBatchSize = 100;

    public void setZkList(String zkList) {
        this.zkList = zkList;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private Connection getConnection() {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        return this.initConnection();
    }

    private synchronized Connection initConnection() {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        try {
            Configuration conf = HBaseConfiguration.create();
            conf.set("hbase.zookeeper.quorum", this.zkList);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.username, this.password})) {
                conf.set("hbase.client.username", this.username);
                conf.set("hbase.client.password", this.password);
            }
            this.connection = ConnectionFactory.createConnection((Configuration)conf);
            return this.connection;
        }
        catch (Exception e) {
            logger.error("initConnection error", (Throwable)e);
            return null;
        }
    }

    private Table getTable(String nameSpace, String tableName) throws Exception {
        Connection connection = this.getConnection();
        if (connection == null) {
            logger.error("can't get hbase connection");
            throw new Exception("can't get hbase connection");
        }
        return connection.getTable(TableName.valueOf((String)nameSpace, (String)tableName));
    }

    private void closeTable(Table table) {
        try {
            if (table != null) {
                table.close();
            }
        }
        catch (Exception e) {
            logger.error("closeTable error.", (Throwable)e);
        }
    }

    private Get get(String rowKey, String family, String column) {
        Get get = new Get(rowKey.getBytes());
        get.addColumn(family.getBytes(), column.getBytes());
        return get;
    }

    private Get get(String rowKey, String family, List<String> columns) {
        Get get = new Get(rowKey.getBytes());
        for (String column : columns) {
            get.addColumn(family.getBytes(), column.getBytes());
        }
        return get;
    }

    private Get get(String rowKey, String family) {
        Get get = new Get(rowKey.getBytes());
        get.addFamily(family.getBytes());
        return get;
    }

    private List<Get> getList(List<String> rowKeyList, String family, String column) {
        ArrayList<Get> getList = new ArrayList<Get>();
        for (String rowKey : rowKeyList) {
            getList.add(this.get(rowKey, family, column));
        }
        return getList;
    }

    private List<Get> getList(List<String> rowKeyList, String family, List<String> columns) {
        ArrayList<Get> getList = new ArrayList<Get>();
        for (String rowKey : rowKeyList) {
            getList.add(this.get(rowKey, family, columns));
        }
        return getList;
    }

    private List<Get> getList(List<String> rowKeyList, String family) {
        ArrayList<Get> getList = new ArrayList<Get>();
        for (String rowKey : rowKeyList) {
            getList.add(this.get(rowKey, family));
        }
        return getList;
    }

    private List<Get> getList(Map<String, List<String>> rowKeyMap, String family) {
        ArrayList<Get> getList = new ArrayList<Get>();
        for (String rowKey : rowKeyMap.keySet()) {
            List<String> columns = rowKeyMap.get(rowKey);
            getList.add(this.get(rowKey, family, columns));
        }
        return getList;
    }

    private Put put(String rowKey, String family, String column, String value) {
        Put put = new Put(rowKey.getBytes());
        put.addColumn(family.getBytes(), column.getBytes(), value.getBytes());
        return put;
    }

    private Put put(String rowKey, String family, Map<String, String> columns) {
        Put put = new Put(rowKey.getBytes());
        for (String column : columns.keySet()) {
            String value = columns.get(column);
            put.addColumn(family.getBytes(), column.getBytes(), value.getBytes());
        }
        return put;
    }

    private List<Put> putList(List<String> rowKeyList, String family, String column, String value) {
        ArrayList<Put> putList = new ArrayList<Put>();
        for (String rowKey : rowKeyList) {
            putList.add(this.put(rowKey, family, column, value));
        }
        return putList;
    }

    private List<Put> putList(Map<String, Map<String, String>> rowKeyMap, String family) {
        ArrayList<Put> putList = new ArrayList<Put>();
        for (String rowKey : rowKeyMap.keySet()) {
            Map<String, String> columns = rowKeyMap.get(rowKey);
            putList.add(this.put(rowKey, family, columns));
        }
        return putList;
    }

    private Delete delete(String rowKey, String family, String column) {
        Delete delete = new Delete(rowKey.getBytes());
        delete.addColumn(family.getBytes(), column.getBytes());
        return delete;
    }

    private Delete delete(String rowKey, String family, List<String> columns) {
        Delete delete = new Delete(rowKey.getBytes());
        for (String column : columns) {
            delete.addColumn(family.getBytes(), column.getBytes());
        }
        return delete;
    }

    private Delete delete(String rowKey, String family) {
        Delete delete = new Delete(rowKey.getBytes());
        delete.addFamily(family.getBytes());
        return delete;
    }

    private List<Delete> delete(List<String> rowKeyList, String family, String column) {
        ArrayList<Delete> deleteList = new ArrayList<Delete>();
        for (String rowKey : rowKeyList) {
            deleteList.add(this.delete(rowKey, family, column));
        }
        return deleteList;
    }

    private List<Delete> delete(Map<String, List<String>> rowKeyMap, String family) {
        ArrayList<Delete> deleteList = new ArrayList<Delete>();
        for (String rowKey : rowKeyMap.keySet()) {
            List<String> columns = rowKeyMap.get(rowKey);
            deleteList.add(this.delete(rowKey, family, columns));
        }
        return deleteList;
    }

    private List<Delete> delete(List<String> rowKeyList, String family) {
        ArrayList<Delete> deleteList = new ArrayList<Delete>();
        for (String rowKey : rowKeyList) {
            deleteList.add(this.delete(rowKey, family));
        }
        return deleteList;
    }

    public Boolean exists(String tableName, String rowKey) {
        return this.exists(this.DEFAULT_NAMESPACE, tableName, rowKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String nameSpace, String tableName, String rowKey) {
        block7: {
            Boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey})) {
                    logger.error("nameSpace/tableName/rowKey is null, please check it.");
                    Boolean bl2 = false;
                    this.closeTable(table);
                    return bl2;
                }
                table = this.getTable(nameSpace, tableName);
                Get get = new Get(rowKey.getBytes());
                bl = table.exists(get);
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("getRow error", (Throwable)e);
                break block7;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    public Result getRow(String tableName, String rowKey, String column) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getRow(String nameSpace, String tableName, String rowKey, String family, String column) {
        block7: {
            Result result;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family, column})) {
                    logger.error("nameSpace/tableName/rowKey/family/column is null, please check it.");
                    Result result2 = null;
                    this.closeTable(table);
                    return result2;
                }
                table = this.getTable(nameSpace, tableName);
                result = table.get(this.get(rowKey, family, column));
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("getRow error", (Throwable)e);
                break block7;
            }
            finally {
                this.closeTable(table);
            }
            return result;
        }
        return null;
    }

    public Result getRow(String tableName, String rowKey, List<String> columns) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns) {
        block9: {
            Result result;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family})) {
                    logger.error("nameSpace/tableName/rowKey/family is null, please check it.");
                    Result result2 = null;
                    return result2;
                }
                if (CollectionUtils.isEmpty(columns)) {
                    logger.error("column list is null, please check it.");
                    Result result3 = null;
                    this.closeTable(table);
                    return result3;
                }
                table = this.getTable(nameSpace, tableName);
                result = table.get(this.get(rowKey, family, columns));
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("getRow error", (Throwable)e);
                break block9;
            }
            finally {
                this.closeTable(table);
            }
            return result;
        }
        return null;
    }

    public Result getRow(String tableName, String rowKey) {
        return this.getRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getRow(String nameSpace, String tableName, String rowKey, String family) {
        block7: {
            Result result;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family})) {
                    logger.error("nameSpace/tableName/rowKey/family is null, please check it.");
                    Result result2 = null;
                    this.closeTable(table);
                    return result2;
                }
                table = this.getTable(nameSpace, tableName);
                result = table.get(this.get(rowKey, family));
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("getRow error", (Throwable)e);
                break block7;
            }
            finally {
                this.closeTable(table);
            }
            return result;
        }
        return null;
    }

    public Result[] getRowList(String tableName, List<String> rowKeyList, String column) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result[] getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, String column) {
        block9: {
            Result[] resultArray;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family, column})) {
                    logger.error("nameSpace/tableName/family/column is null, please check it.");
                    Result[] resultArray2 = null;
                    return resultArray2;
                }
                if (CollectionUtils.isEmpty(rowKeyList)) {
                    logger.error("rowKey list is null, please check it.");
                    Result[] resultArray3 = null;
                    this.closeTable(table);
                    return resultArray3;
                }
                table = this.getTable(nameSpace, tableName);
                resultArray = table.get(this.getList(rowKeyList, family, column));
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("getRow error", (Throwable)e);
                break block9;
            }
            finally {
                this.closeTable(table);
            }
            return resultArray;
        }
        return null;
    }

    public Result[] getRowList(String tableName, List<String> rowKeyList, List<String> columns) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result[] getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family, List<String> columns) {
        Table table = null;
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family})) {
                logger.error("nameSpace/tableName/family is null, please check it.");
                Result[] resultArray = null;
                return resultArray;
            }
            if (CollectionUtils.isEmpty(rowKeyList) || CollectionUtils.isEmpty(columns)) {
                logger.error("rowKeyList/columnList is null, please check it.");
                Result[] resultArray = null;
                return resultArray;
            }
            table = this.getTable(nameSpace, tableName);
            Result[] resultArray = table.get(this.getList(rowKeyList, family, columns));
            this.closeTable(table);
            return resultArray;
        }
        catch (Exception e) {
            logger.error("getRowList error", (Throwable)e);
        }
        finally {
            this.closeTable(table);
        }
        return null;
    }

    public Result[] getRowList(String tableName, List<String> rowKeyList) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyList, this.DEFAULT_COLUMN_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result[] getRowList(String nameSpace, String tableName, List<String> rowKeyList, String family) {
        block9: {
            Result[] resultArray;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family})) {
                    logger.error("nameSpace/tableName/family is null, please check it.");
                    Result[] resultArray2 = null;
                    return resultArray2;
                }
                if (CollectionUtils.isEmpty(rowKeyList)) {
                    logger.error("rowKey list is null, please check it.");
                    Result[] resultArray3 = null;
                    this.closeTable(table);
                    return resultArray3;
                }
                table = this.getTable(nameSpace, tableName);
                resultArray = table.get(this.getList(rowKeyList, family));
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("getRowList error", (Throwable)e);
                break block9;
            }
            finally {
                this.closeTable(table);
            }
            return resultArray;
        }
        return null;
    }

    public Result[] getRowList(String tableName, Map<String, List<String>> rowKeyMap) {
        return this.getRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result[] getRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family) {
        Table table = null;
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family})) {
                logger.error("nameSpace/tableName/family is null, please check it.");
                Result[] resultArray = null;
                return resultArray;
            }
            if (rowKeyMap == null || rowKeyMap.size() == 0) {
                logger.error("rowKeyMap is null, please check it.");
                Result[] resultArray = null;
                return resultArray;
            }
            table = this.getTable(nameSpace, tableName);
            Result[] resultArray = table.get(this.getList(rowKeyMap, family));
            this.closeTable(table);
            return resultArray;
        }
        catch (Exception e) {
            logger.error("getRowList error", (Throwable)e);
        }
        finally {
            this.closeTable(table);
        }
        return null;
    }

    public boolean insert(String tableName, String rowKey, String column, String value) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(String nameSpace, String tableName, String rowKey, String family, String column, String value) {
        block7: {
            boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family, column, value})) {
                    logger.error("nameSpace/tableName/rowKey/family/column/value is null, please check it.");
                    boolean bl2 = false;
                    this.closeTable(table);
                    return bl2;
                }
                table = this.getTable(nameSpace, tableName);
                table.put(this.put(rowKey, family, column, value));
                bl = true;
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("insert error", (Throwable)e);
                break block7;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    public boolean insert(String tableName, String rowKey, Map<String, String> columns) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(String nameSpace, String tableName, String rowKey, String family, Map<String, String> columns) {
        Table table = null;
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family})) {
                logger.error("nameSpace/tableName/rowKey/family is null, please check it.");
                boolean bl = false;
                return bl;
            }
            if (columns == null || columns.size() == 0) {
                logger.error("columnMap is null, please check it.");
                boolean bl = false;
                return bl;
            }
            table = this.getTable(nameSpace, tableName);
            table.put(this.put(rowKey, family, columns));
            boolean bl = true;
            this.closeTable(table);
            return bl;
        }
        catch (Exception e) {
            logger.error("insert error", (Throwable)e);
        }
        finally {
            this.closeTable(table);
        }
        return false;
    }

    public boolean insert(String tableName, List<String> rowkeyList, String column, String value) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY, column, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(String nameSpace, String tableName, List<String> rowkeyList, String family, String column, String value) {
        block9: {
            boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family, column, value})) {
                    logger.error("nameSpace/tableName/family/column/value is null, please check it.");
                    boolean bl2 = false;
                    return bl2;
                }
                if (CollectionUtils.isEmpty(rowkeyList)) {
                    logger.error("rowkeyList is null, please check it.");
                    boolean bl3 = false;
                    this.closeTable(table);
                    return bl3;
                }
                table = this.getTable(nameSpace, tableName);
                List<Put> allPutList = this.putList(rowkeyList, family, column, value);
                this.batchInsert(allPutList, table);
                bl = true;
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("insert error", (Throwable)e);
                break block9;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    public boolean insert(String tableName, Map<String, Map<String, String>> rowKeyMap) {
        return this.insert(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(String nameSpace, String tableName, Map<String, Map<String, String>> rowKeyMap, String family) {
        Table table = null;
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family})) {
                logger.error("nameSpace/tableName/family is null, please check it.");
                boolean bl = false;
                return bl;
            }
            if (rowKeyMap == null || rowKeyMap.size() == 0) {
                logger.error("rowKeyMap is null, please check it.");
                boolean bl = false;
                return bl;
            }
            table = this.getTable(nameSpace, tableName);
            List<Put> allPutList = this.putList(rowKeyMap, family);
            this.batchInsert(allPutList, table);
            boolean bl = true;
            this.closeTable(table);
            return bl;
        }
        catch (Exception e) {
            logger.error("insert error", (Throwable)e);
        }
        finally {
            this.closeTable(table);
        }
        return false;
    }

    public boolean deleteRow(String tableName, String rowKey, String column) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family, String column) {
        block7: {
            boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family, column})) {
                    logger.error("nameSpace/tableName/rowKey/family/column is null, please check it.");
                    boolean bl2 = false;
                    this.closeTable(table);
                    return bl2;
                }
                table = this.getTable(nameSpace, tableName);
                table.delete(this.delete(rowKey, family, column));
                bl = true;
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("delete error", (Throwable)e);
                break block7;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    public boolean deleteRow(String tableName, String rowKey, List<String> columns) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family, List<String> columns) {
        block9: {
            boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family})) {
                    logger.error("nameSpace/tableName/rowKey/family is null, please check it.");
                    boolean bl2 = false;
                    return bl2;
                }
                if (CollectionUtils.isEmpty(columns)) {
                    logger.error("columnMap is null, please check it.");
                    boolean bl3 = false;
                    this.closeTable(table);
                    return bl3;
                }
                table = this.getTable(nameSpace, tableName);
                table.delete(this.delete(rowKey, family, columns));
                bl = true;
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("delete error", (Throwable)e);
                break block9;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    public boolean deleteRow(String tableName, String rowKey) {
        return this.deleteRow(this.DEFAULT_NAMESPACE, tableName, rowKey, this.DEFAULT_COLUMN_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRow(String nameSpace, String tableName, String rowKey, String family) {
        block7: {
            boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, rowKey, family})) {
                    logger.error("nameSpace/tableName/rowKey/family is null, please check it.");
                    boolean bl2 = false;
                    this.closeTable(table);
                    return bl2;
                }
                table = this.getTable(nameSpace, tableName);
                table.delete(this.delete(rowKey, family));
                bl = true;
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("delete error", (Throwable)e);
                break block7;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    public boolean deleteRowList(String tableName, List<String> rowkeyList, String column) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRowList(String nameSpace, String tableName, List<String> rowkeyList, String family, String column) {
        block9: {
            boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family, column})) {
                    logger.error("nameSpace/tableName/family/column is null, please check it.");
                    boolean bl2 = false;
                    return bl2;
                }
                if (CollectionUtils.isEmpty(rowkeyList)) {
                    logger.error("rowkeyList is null, please check it.");
                    boolean bl3 = false;
                    this.closeTable(table);
                    return bl3;
                }
                table = this.getTable(nameSpace, tableName);
                table.delete(this.delete(rowkeyList, family, column));
                bl = true;
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("delete error", (Throwable)e);
                break block9;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    public boolean deleteRowList(String tableName, Map<String, List<String>> rowKeyMap) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowKeyMap, this.DEFAULT_COLUMN_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRowList(String nameSpace, String tableName, Map<String, List<String>> rowKeyMap, String family) {
        Table table = null;
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family})) {
                logger.error("nameSpace/tableName/family is null, please check it.");
                boolean bl = false;
                return bl;
            }
            if (rowKeyMap == null || rowKeyMap.size() == 0) {
                logger.error("rowKeyMap is null, please check it.");
                boolean bl = false;
                return bl;
            }
            table = this.getTable(nameSpace, tableName);
            table.delete(this.delete(rowKeyMap, family));
            boolean bl = true;
            this.closeTable(table);
            return bl;
        }
        catch (Exception e) {
            logger.error("delete error", (Throwable)e);
        }
        finally {
            this.closeTable(table);
        }
        return false;
    }

    public boolean deleteRowList(String tableName, List<String> rowkeyList) {
        return this.deleteRowList(this.DEFAULT_NAMESPACE, tableName, rowkeyList, this.DEFAULT_COLUMN_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRowList(String nameSpace, String tableName, List<String> rowkeyList, String family) {
        block9: {
            boolean bl;
            Table table = null;
            try {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nameSpace, tableName, family})) {
                    logger.error("nameSpace/tableName/family is null, please check it.");
                    boolean bl2 = false;
                    return bl2;
                }
                if (CollectionUtils.isEmpty(rowkeyList)) {
                    logger.error("rowkeyList is null, please check it.");
                    boolean bl3 = false;
                    this.closeTable(table);
                    return bl3;
                }
                table = this.getTable(nameSpace, tableName);
                table.delete(this.delete(rowkeyList, family));
                bl = true;
                this.closeTable(table);
            }
            catch (Exception e) {
                logger.error("delete error", (Throwable)e);
                break block9;
            }
            finally {
                this.closeTable(table);
            }
            return bl;
        }
        return false;
    }

    private void batchInsert(List<Put> allPutList, Table table) throws IOException {
        if (allPutList.size() <= 100) {
            this.insert(allPutList, table);
        } else {
            ArrayList<Put> putList = new ArrayList<Put>();
            for (Put put : allPutList) {
                putList.add(put);
                if (putList.size() < 100) continue;
                this.insert(putList, table);
                putList.clear();
            }
            if (putList.size() > 0) {
                this.insert(putList, table);
            }
        }
    }

    private void insert(List<Put> allPutList, Table table) throws IOException {
        table.put(allPutList);
    }
}

