package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf
 * hologres指标字段
 */
public enum HologresMetricEnum {

    //广告位曝光pv
    SLOT_EXPOSURE_PV("slotExposurePV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type in ('2', '151')", "广告位曝光pv", "SLOT_EXPOSURE_UV"),

    //广告位曝光uv
    SLOT_EXPOSURE_UV("slotExposureUV", "approx_count_distinct(consumer_id)", "duiba_inner_log", "inner_group = '1' and inner_type in ('2', '151')", "广告位曝光uv", "SLOT_EXPOSURE_PV"),

    //广告位点击pv
    SLOT_CLICK_PV("slotClickPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type in ('3', '152')", "广告位点击pv", "SLOT_CLICK_UV"),

    //广告位点击uv
    SLOT_CLICK_UV("slotClickUV", "approx_count_distinct(consumer_id)", "duiba_inner_log", "inner_group = '1' and inner_type in ('3', '152')", "广告位点击uv", "SLOT_CLICK_PV"),

    //广告位访问pv
    SLOT_VISIT_PV("slotVisitPV", "count(1)", "duiba_access_log", "url_host = 'activity.tuia.cn' and http_method = 'GET' and tenter='SOW'", "广告位访问pv", "SLOT_VISIT_UV"),

    //广告位访问uv
    SLOT_VISIT_UV("slotVisitUV", "approx_count_distinct(consumer_id)", "duiba_access_log", "url_host = 'activity.tuia.cn' and http_method = 'GET' and tenter='SOW'", "广告位访问uv", "SLOT_VISIT_PV"),

    //媒体线-活动请求pv
    APP_ACTIVITY_REQUEST_PV("appActivityRequestPV", "count(1)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex')", "活动请求pv", "APP_ACTIVITY_REQUEST_UV"),

    //媒体线-活动请求uv
    APP_ACTIVITY_REQUEST_UV("appActivityRequestUV", "approx_count_distinct(consumer_id)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex')", "活动请求uv", "APP_ACTIVITY_REQUEST_PV"),

    //媒体线-活动参与pv
    APP_ACTIVITY_JOIN_PV("appActivityJoinPV", "count(1)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与pv", "APP_ACTIVITY_JOIN_UV"),

    //媒体线-活动参与uv
    APP_ACTIVITY_JOIN_UV("appActivityJoinUV", "approx_count_distinct(consumer_id)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与uv", "APP_ACTIVITY_JOIN_PV"),

    //活动线-活动请求pv
    ACTIVITY_REQUEST_PV("activityRequestPV", "count(1)", "duiba_access_log", "activity_stage = '2'", "活动请求pv", "ACTIVITY_REQUEST_UV"),

    //活动线-活动请求uv
    ACTIVITY_REQUEST_UV("activityRequestUV", "approx_count_distinct(consumer_id)", "duiba_access_log", "activity_stage = '2'", "活动请求uv", "ACTIVITY_REQUEST_PV"),

    //活动线-活动参与pv
    ACTIVITY_JOIN_PV("activityJoinPV", "count(1)", "duiba_access_log", "activity_stage = '3'", "活动参与pv", "ACTIVITY_JOIN_UV"),

    //活动线-活动参与uv
    ACTIVITY_JOIN_UV("activityJoinUV", "approx_count_distinct(consumer_id)", "duiba_access_log", "activity_stage = '3'", "活动参与uv", "ACTIVITY_JOIN_PV"),

    //券请求pv
    COUPON_REQUEST_PV("couponRequestPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '23'", "券请求pv", ""),

    //发券量pv
    LAUNCH_COUPON_PV("launchCouponPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '20'", "发券量pv", ""),

    //付费券发券量pv
    LAUNCH_PAY_COUPON_PV("launchPayCouponPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '20' and is_free = '0'", "付费券发券量pv", ""),

    //券曝光pv
    COUPON_EXPOSURE_PV("couponExposurePV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '22'", "券曝光pv", ""),

    //券点击pv
    COUPON_CLICK_PV("couponClickPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '25'", "券点击pv", "CONSUME"),

    //消耗
    CONSUME("consume", "sum(fee)", "duiba_inner_log", "inner_group = '1' and inner_type = '25'", "消耗", "COUPON_CLICK_PV"),

    //落地页曝光pv
    LP_EXPOSE_PV("lpExposePV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '7'", "落地页曝光pv", ""),

    //落地页转化pv
    LP_CLICK_PV("lpClickPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '8'", "落地页转化pv", ""),

    //表单类落地页转化pv
    FORM_LP_CLICK_PV("formLpClickPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '8' and form_advert = '1'", "表单类落地页转化pv", ""),

    //表单类券点击pv
    FORM_COUPON_CLICK_PV("formCouponClickPV", "count(1)", "duiba_inner_log", "inner_group = '1' and inner_type = '25' and form_advert = '1'", "表单类券点击pv", "");



    //指标字段名称
    private String fieldName;

    //指标sql代码段
    private String metricSql;

    //指标对应的 database
    private String database;

    //指标特定的查询条件
    private String condition;

    //指标解释说明
    private String desc;

    //可以进行合并查询的指标，多个指标用 "," 分隔
    private String mergeMetrics;

    HologresMetricEnum(String fieldName, String metricSql, String database, String condition, String desc, String mergeMetrics) {
        this.fieldName = fieldName;
        this.metricSql = metricSql;
        this.database = database;
        this.condition = condition;
        this.desc = desc;
        this.mergeMetrics = mergeMetrics;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getDatabase() {
        return database;
    }

    public String getCondition() {
        return condition;
    }

    public String getDesc() {
        return desc;
    }

    public String getMergeMetrics() {
        return mergeMetrics;
    }
}
