/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisUtil {
    private final int piplineBatch = 1000;
    private StringRedisTemplate stringRedisTemplate;

    public RedisUtil() {
    }

    public RedisUtil(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public boolean exist(String key) {
        return this.getStringRedisTemplate().hasKey((Object)key);
    }

    public void delete(String key) {
        this.getStringRedisTemplate().delete((Object)key);
    }

    public Long increment(String key, long delta) {
        return this.getStringRedisTemplate().opsForValue().increment((Object)key, delta);
    }

    public String get(String key) {
        return (String)this.getStringRedisTemplate().opsForValue().get((Object)key);
    }

    public void set(String key, String value, long timeout, TimeUnit unit) {
        this.getStringRedisTemplate().opsForValue().set((Object)key, (Object)value, timeout, unit);
    }

    public void set(String key, String value, long offset) {
        this.getStringRedisTemplate().opsForValue().set((Object)key, (Object)value, offset);
    }

    public void set(String key, String value) {
        this.getStringRedisTemplate().opsForValue().set((Object)key, (Object)value);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.getStringRedisTemplate().expire((Object)key, timeout, unit);
    }

    public <V> V hGet(String key, Object hashKey) {
        return (V)this.getStringRedisTemplate().opsForHash().get((Object)key, hashKey);
    }

    public void hSet(String key, Object hashKey, Object value) {
        this.getStringRedisTemplate().opsForHash().put((Object)key, hashKey, value);
    }

    public void hSetAll(String key, Map<String, String> hashMap) {
        this.getStringRedisTemplate().opsForHash().putAll((Object)key, hashMap);
    }

    public void hDel(String key, Object ... hashKey) {
        this.getStringRedisTemplate().opsForHash().delete((Object)key, hashKey);
    }

    public List<Object> hValues(String key) {
        return this.getStringRedisTemplate().opsForHash().values((Object)key);
    }

    public <HK, HV> Map<HK, HV> entries(String key) {
        return this.getStringRedisTemplate().opsForHash().entries((Object)key);
    }

    public Long hIncr(String key, Object hashKey, Long delta) {
        return this.getStringRedisTemplate().opsForHash().increment((Object)key, hashKey, delta.longValue());
    }

    public boolean addSet(String key, String value) {
        return this.getStringRedisTemplate().opsForSet().add((Object)key, (Object[])new String[]{value}) > 0L;
    }

    public Set<String> getSet(String key) {
        return this.getStringRedisTemplate().opsForSet().members((Object)key);
    }

    public void flushAll() {
        this.getStringRedisTemplate().execute(connection -> {
            connection.flushAll();
            return null;
        });
    }

    public Map<String, String> hgetAll(String key) {
        Map mapValue;
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        Map valMap = mapValue = this.getStringRedisTemplate().opsForHash().entries((Object)key);
        HashMap<String, String> hMap = new HashMap<String, String>();
        valMap.forEach((vkey, val) -> hMap.put(vkey.toString(), val.toString()));
        return hMap;
    }

    public Object execute(String command, byte[] ... args) {
        return this.getStringRedisTemplate().execute(connection -> connection.execute(command, args));
    }

    public Map<String, String> pipelineGet(List<String> keys) {
        if (keys.size() <= 1000) {
            return this.pipelineGetNoBatch(keys);
        }
        HashMap<String, String> valueMap = new HashMap<String, String>(keys.size());
        List parts = Lists.partition(keys, (int)1000);
        parts.forEach(subKeys -> valueMap.putAll(this.pipelineGetNoBatch((List<String>)subKeys)));
        return valueMap;
    }

    public Map<String, String> pipelineHget(List<String> keys, String field) {
        if (keys.size() <= 1000) {
            return this.pipelineHgetNoBatch(keys, field);
        }
        HashMap<String, String> valueMap = new HashMap<String, String>(keys.size());
        List parts = Lists.partition(keys, (int)1000);
        parts.forEach(subKeys -> valueMap.putAll(this.pipelineHgetNoBatch((List<String>)subKeys, field)));
        return valueMap;
    }

    public void pipelineHmsetex(final Map<String, Map<String, String>> dataMap, final int expire) {
        if (MapUtils.isEmpty(dataMap)) {
            return;
        }
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (Map.Entry entry : dataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Map value = (Map)entry.getValue();
                    template.opsForHash().putAll((Object)key, value);
                    template.expire((Object)key, (long)expire, TimeUnit.SECONDS);
                }
                return null;
            }
        });
    }

    public void pipelineMsetex(final Map<String, String> dataMap, final int expire) {
        if (MapUtils.isEmpty(dataMap)) {
            return;
        }
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (Map.Entry entry : dataMap.entrySet()) {
                    template.opsForValue().set(entry.getKey(), entry.getValue(), (long)expire, TimeUnit.SECONDS);
                }
                return null;
            }
        });
    }

    public Map<String, Boolean> pipelineExist(final List<String> keys) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (CollectionUtils.isEmpty(keys)) {
            return map;
        }
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (String key : keys) {
                    template.hasKey((Object)key);
                }
                return null;
            }
        });
        for (int index = 0; index < keys.size(); ++index) {
            Object pipResult = pipResults.get(index);
            String key = keys.get(index);
            if (pipResult == null) continue;
            Boolean val = (Boolean)pipResult;
            map.put(key, val);
        }
        return map;
    }

    public void pipelineSadd(final Map<String, Set<String>> map, final int expire) {
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Set value = (Set)entry.getValue();
                    template.opsForSet().add((Object)key, (Object[])value.toArray(new String[value.size()]));
                    template.expire((Object)key, (long)expire, TimeUnit.SECONDS);
                }
                return null;
            }
        });
    }

    public void pipelineMsetex(final Map<Integer, Map<String, String>> dataMap) {
        if (MapUtils.isEmpty(dataMap)) {
            return;
        }
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (Map.Entry expireEntry : dataMap.entrySet()) {
                    for (Map.Entry entry : ((Map)expireEntry.getValue()).entrySet()) {
                        template.opsForValue().set(entry.getKey(), entry.getValue(), (long)((Integer)expireEntry.getKey()).intValue(), TimeUnit.SECONDS);
                    }
                }
                return null;
            }
        });
    }

    private Map<String, String> pipelineGetNoBatch(final List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap<String, String>();
        }
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        HashMap<String, String> valueMap = new HashMap<String, String>(keys.size());
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (String key : keys) {
                    template.opsForValue().get((Object)key);
                }
                return null;
            }
        });
        for (int index = 0; index < keys.size(); ++index) {
            Object pipResult = pipResults.get(index);
            String key = keys.get(index);
            if (pipResult == null) continue;
            valueMap.put(key, pipResult.toString());
        }
        return valueMap;
    }

    private Map<String, String> pipelineHgetNoBatch(final List<String> keys, final String field) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap<String, String>();
        }
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        HashMap<String, String> valueMap = new HashMap<String, String>(keys.size());
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (String key : keys) {
                    template.opsForHash().get((Object)key, (Object)field);
                }
                return null;
            }
        });
        for (int index = 0; index < keys.size(); ++index) {
            Object pipResult = pipResults.get(index);
            String key = keys.get(index);
            if (pipResult == null) continue;
            valueMap.put(key, pipResult.toString());
        }
        return valueMap;
    }

    public Map<String, Map<String, String>> pipelineHget(List<String> keys) {
        if (keys.size() <= 1000) {
            return this.pipelineHgetAllNoBatch(keys);
        }
        HashMap<String, Map<String, String>> valuesMap = new HashMap<String, Map<String, String>>(keys.size());
        List parts = Lists.partition(keys, (int)1000);
        parts.forEach(subKeys -> valuesMap.putAll(this.pipelineHgetAllNoBatch((List<String>)subKeys)));
        return valuesMap;
    }

    private Map<String, Map<String, String>> pipelineHgetAllNoBatch(final List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap<String, Map<String, String>>();
        }
        StringRedisTemplate redisTemplate = this.getStringRedisTemplate();
        HashMap<String, Map<String, String>> valuesMap = new HashMap<String, Map<String, String>>(keys.size());
        List pipResults = redisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (String key : keys) {
                    template.opsForHash().entries((Object)key);
                }
                return null;
            }
        });
        for (int index = 0; index < keys.size(); ++index) {
            Object pipResult = pipResults.get(index);
            String key = keys.get(index);
            if (pipResult == null) continue;
            Map valMap = (Map)pipResult;
            HashMap hMap = new HashMap();
            valMap.forEach((vkey, val) -> {
                if (vkey != null && val != null) {
                    hMap.put(vkey.toString(), val.toString());
                }
            });
            valuesMap.put(key, hMap);
        }
        return valuesMap;
    }
}

