/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Tuple;

public class JedisUtil {
    private JedisPoolConfig poolConfig;
    private JedisPool jedisPool;
    private String host;
    private String auth;
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_TIMEOUT = 2000;

    public void setPoolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    private Jedis getJedis() {
        if (this.jedisPool == null || this.jedisPool.isClosed()) {
            this.initJedisPool();
        }
        return this.jedisPool.getResource();
    }

    private void closeJedis(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    private synchronized void initJedisPool() {
        if (this.jedisPool != null && !this.jedisPool.isClosed()) {
            return;
        }
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)this.poolConfig, this.host, 6379, 2000, this.auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, String member, double score) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.zadd(key, score, member);
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.zadd(key, scoreMembers);
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcard(String key) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.zcard(key);
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple zpopmin(String key) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Tuple tuple = jedis.zpopmin(key);
            return tuple;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zpopmin(String key, int count) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Set set = jedis.zpopmin(key, count);
            return set;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple zpopmax(String key) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Tuple tuple = jedis.zpopmax(key);
            return tuple;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zpopmax(String key, int count) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Set set = jedis.zpopmax(key, count);
            return set;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrem(String key, String ... members) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.zrem(key, members);
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.del(key);
            return l;
        }
        finally {
            this.closeJedis(jedis);
        }
    }
}

