/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewLabelDepartUtil {
    private static final Logger log = LoggerFactory.getLogger(NewLabelDepartUtil.class);
    public static final String QUESTION_MARK = "?";

    public static void main(String[] args) {
        String s = "(((((?010102||?010101)||(?010401))||(?01050202||?01050201))||(?020405||?020401))||(?030413||?030406))";
        ArrayList labelSet = Lists.newArrayList();
        NewLabelDepartUtil.distributiveLabelFilterRule(s, labelSet);
        System.out.println(JSONObject.toJSONString((Object)labelSet));
    }

    public static List<String> distributiveLabelFilterRule(String labelFilterRule, List<String> labelSet) {
        if (StringUtils.isEmpty((String)labelFilterRule) || !labelFilterRule.contains(QUESTION_MARK)) {
            return null;
        }
        try {
            Expr expr = ExprUtils.parse((String)labelFilterRule);
            if (expr instanceof ExprVar) {
                labelSet.add(expr.toString());
            } else if (expr instanceof E_LogicalAnd) {
                E_LogicalAnd e_logicalAnd = (E_LogicalAnd)expr;
                String opName = e_logicalAnd.getOpName();
                ArrayList left = Lists.newArrayList();
                NewLabelDepartUtil.distributiveLabelFilterRule(e_logicalAnd.getArg1().toString(), left);
                ArrayList right = Lists.newArrayList();
                NewLabelDepartUtil.distributiveLabelFilterRule(e_logicalAnd.getArg2().toString(), right);
                for (String l : left) {
                    for (String r : right) {
                        StringBuilder sb = new StringBuilder();
                        labelSet.add(sb.append("(").append(l).append(" ").append(opName).append(" ").append(r).append(")").toString());
                    }
                }
            } else if (expr instanceof E_LogicalOr) {
                E_LogicalOr e_logicalOr = (E_LogicalOr)expr;
                ArrayList left = Lists.newArrayList();
                if (e_logicalOr.getArg1() instanceof ExprVar) {
                    NewLabelDepartUtil.concatStrForLogicalOr(e_logicalOr.getArg1(), left);
                } else {
                    ExprFunction2 leftSub = (ExprFunction2)e_logicalOr.getArg1();
                    NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg1(), left);
                    NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg2(), left);
                }
                ArrayList right = Lists.newArrayList();
                if (e_logicalOr.getArg2() instanceof ExprVar) {
                    NewLabelDepartUtil.concatStrForLogicalOr(e_logicalOr.getArg2(), right);
                } else {
                    ExprFunction2 rightSub = (ExprFunction2)e_logicalOr.getArg2();
                    NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg1(), right);
                    NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg2(), right);
                }
                labelSet.addAll(left);
                labelSet.addAll(right);
            }
        }
        catch (Exception e) {
            log.warn("LabelSetTransformUtil.exprDistributiveLabelSet labelFilterRule = {} error = {}", (Object)labelFilterRule, (Object)e);
        }
        return labelSet;
    }

    public static List<String> distributiveLabelFilterRule(String labelFilterRule) {
        if (StringUtils.isEmpty((String)labelFilterRule) || !labelFilterRule.contains(QUESTION_MARK)) {
            return null;
        }
        ArrayList labelSet = Lists.newArrayList();
        try {
            Expr expr = ExprUtils.parse((String)labelFilterRule);
            if (expr instanceof E_LogicalAnd) {
                E_LogicalAnd e_logicalAnd = (E_LogicalAnd)expr;
                String opName = e_logicalAnd.getOpName();
                ArrayList left = Lists.newArrayList();
                if (e_logicalAnd.getArg1() instanceof ExprVar) {
                    NewLabelDepartUtil.concatStrForLogicalOr(e_logicalAnd.getArg1(), left);
                } else {
                    ExprFunction2 leftSub = (ExprFunction2)e_logicalAnd.getArg1();
                    if (leftSub instanceof E_LogicalOr) {
                        NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg1(), left);
                        NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg2(), left);
                    } else if (leftSub instanceof E_LogicalAnd) {
                        ArrayList ll = Lists.newArrayList();
                        ArrayList rr = Lists.newArrayList();
                        NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg1(), ll);
                        NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg2(), rr);
                        for (Object l : ll) {
                            for (String r : rr) {
                                StringBuilder sb = new StringBuilder();
                                left.add(sb.append("(").append((String)l).append(" ").append(opName).append(" ").append(r).append(")").toString());
                            }
                        }
                    }
                }
                ArrayList right = Lists.newArrayList();
                if (e_logicalAnd.getArg2() instanceof ExprVar) {
                    NewLabelDepartUtil.concatStrForLogicalOr(e_logicalAnd.getArg2(), right);
                } else {
                    ExprFunction2 rightSub = (ExprFunction2)e_logicalAnd.getArg2();
                    if (rightSub instanceof E_LogicalAnd) {
                        ArrayList ll = Lists.newArrayList();
                        ArrayList rr = Lists.newArrayList();
                        NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg1(), ll);
                        NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg2(), rr);
                        for (String l : ll) {
                            for (String r : rr) {
                                StringBuilder sb = new StringBuilder();
                                right.add(sb.append("(").append(l).append(" ").append(opName).append(" ").append(r).append(")").toString());
                            }
                        }
                    } else if (rightSub instanceof E_LogicalOr) {
                        NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg1(), right);
                        NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg2(), right);
                    }
                }
                for (String l : left) {
                    for (String r : right) {
                        StringBuilder sb = new StringBuilder();
                        labelSet.add(sb.append("(").append(l).append(" ").append(opName).append(" ").append(r).append(")").toString());
                    }
                }
            } else if (expr instanceof E_LogicalOr) {
                E_LogicalOr e_logicalOr = (E_LogicalOr)expr;
                ArrayList left = Lists.newArrayList();
                if (e_logicalOr.getArg1() instanceof ExprVar) {
                    NewLabelDepartUtil.concatStrForLogicalOr(e_logicalOr.getArg1(), left);
                } else {
                    ExprFunction2 leftSub = (ExprFunction2)e_logicalOr.getArg1();
                    NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg1(), left);
                    NewLabelDepartUtil.concatStrForLogicalOr(leftSub.getArg2(), left);
                }
                ArrayList right = Lists.newArrayList();
                if (e_logicalOr.getArg2() instanceof ExprVar) {
                    NewLabelDepartUtil.concatStrForLogicalOr(e_logicalOr.getArg2(), right);
                } else {
                    ExprFunction2 rightSub = (ExprFunction2)e_logicalOr.getArg2();
                    NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg1(), right);
                    NewLabelDepartUtil.concatStrForLogicalOr(rightSub.getArg2(), right);
                }
                labelSet.addAll(left);
                labelSet.addAll(right);
            } else if (expr instanceof ExprVar) {
                labelSet.add(expr.toString());
            }
        }
        catch (Exception e) {
            log.warn("LabelSetTransformUtil.exprDistributiveLabelSet labelFilterRule = {} error = {}", (Object)labelFilterRule, (Object)e);
        }
        return labelSet;
    }

    public static List<String> fetchLabelComposeElements(String labelCompose) {
        if (StringUtils.isEmpty((String)labelCompose) || !labelCompose.contains(QUESTION_MARK)) {
            return null;
        }
        try {
            ArrayList elements = Lists.newArrayList();
            Expr expr = ExprUtils.parse((String)labelCompose);
            NewLabelDepartUtil.fetchElementFromLogical(expr, elements);
            return elements;
        }
        catch (Exception e) {
            log.warn("LabelSetTransformUtil.fetchLabelComposeElements labelCompose = {} error ={} ", (Object)labelCompose, (Object)e);
            return null;
        }
    }

    public static String concatStrForLogicalOr(Expr expr, List<String> param) {
        if (expr instanceof ExprVar) {
            ExprVar ev = (ExprVar)expr;
            param.add(ev.toString());
            return null;
        }
        if (expr instanceof E_LogicalOr) {
            String s2;
            E_LogicalOr ssub1 = (E_LogicalOr)expr;
            String s1 = NewLabelDepartUtil.concatStrForLogicalOr(ssub1.getArg1(), param);
            if (StringUtils.isNotEmpty((String)s1)) {
                param.add(s1);
            }
            if (StringUtils.isNotEmpty((String)(s2 = NewLabelDepartUtil.concatStrForLogicalOr(ssub1.getArg2(), param)))) {
                param.add(s2);
            }
            return null;
        }
        if (expr instanceof E_LogicalAnd) {
            ExprFunction2 ssub1 = (ExprFunction2)expr;
            String opName = ssub1.getOpName();
            ArrayList ll = Lists.newArrayList();
            ArrayList rr = Lists.newArrayList();
            NewLabelDepartUtil.concatStrForLogicalOr(ssub1.getArg1(), ll);
            NewLabelDepartUtil.concatStrForLogicalOr(ssub1.getArg2(), rr);
            for (String l : ll) {
                for (String r : rr) {
                    StringBuilder sb = new StringBuilder();
                    if (StringUtils.equalsIgnoreCase((String)l, (String)r)) {
                        param.add(sb.append("(").append(l).append(")").toString());
                        continue;
                    }
                    param.add(sb.append("(").append(l).append(" ").append(opName).append(" ").append(r).append(")").toString());
                }
            }
            return null;
        }
        return null;
    }

    public static String fetchElementFromLogical(Expr expr, List<String> elements) {
        if (expr instanceof ExprVar) {
            ExprVar ev = (ExprVar)expr;
            elements.add(ev.getVarName());
            return null;
        }
        if (expr instanceof E_LogicalOr) {
            String s2;
            E_LogicalOr e_logicalOr = (E_LogicalOr)expr;
            String s1 = NewLabelDepartUtil.fetchElementFromLogical(e_logicalOr.getArg1(), elements);
            if (StringUtils.isNotEmpty((String)s1)) {
                elements.add(s1);
            }
            if (StringUtils.isNotEmpty((String)(s2 = NewLabelDepartUtil.fetchElementFromLogical(e_logicalOr.getArg2(), elements)))) {
                elements.add(s2);
            }
            return null;
        }
        if (expr instanceof E_LogicalAnd) {
            String s2;
            E_LogicalAnd e_logicalAnd = (E_LogicalAnd)expr;
            String s1 = NewLabelDepartUtil.fetchElementFromLogical(e_logicalAnd.getArg1(), elements);
            if (StringUtils.isNotEmpty((String)s1)) {
                elements.add(s1);
            }
            if (StringUtils.isNotEmpty((String)(s2 = NewLabelDepartUtil.fetchElementFromLogical(e_logicalAnd.getArg2(), elements)))) {
                elements.add(s2);
            }
            return null;
        }
        return null;
    }
}

