/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.service;

import cn.com.duiba.bigdata.common.biz.entity.redis.BigdataRedisMetricsEntity;
import cn.com.duiba.bigdata.common.biz.utils.BigdataUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonService.class);
    private static final String SUFFIX = "_a_fee";

    public static BigdataRedisMetricsEntity getBigdataRedisMetricsEntity(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        BigdataRedisMetricsEntity info = new BigdataRedisMetricsEntity();
        info.setBackendCntMap(BigdataUtil.getBackendCntMap(map));
        info.setBackendAFeeMap(CommonService.getBackendAFeeMap(map));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case "a_r": {
                    info.setActivityRequest(Long.parseLong(value));
                    break;
                }
                case "a_j": {
                    info.setActivityJoin(Long.parseLong(value));
                    break;
                }
                case "l_e": {
                    info.setLandpageExposure(Long.parseLong(value));
                    break;
                }
                case "l_c": {
                    info.setLandpageClick(Long.parseLong(value));
                    break;
                }
                case "l": {
                    info.setLaunch(Long.parseLong(value));
                    break;
                }
                case "ef_c": {
                    info.setEffectClick(Long.parseLong(value));
                    break;
                }
                case "f": {
                    info.setFee(Long.parseLong(value));
                    break;
                }
                case "cpc_f": {
                    info.setCpcFee(Long.parseLong(value));
                    break;
                }
                case "m_f": {
                    info.setMinFee(Long.parseLong(value));
                    break;
                }
                case "c": {
                    info.setClick(Long.parseLong(value));
                    break;
                }
                case "a_e": {
                    info.setAdvertExposure(Long.parseLong(value));
                    break;
                }
                case "s_e": {
                    info.setSdkSlotExposure(Long.parseLong(value));
                    break;
                }
                case "s_c": {
                    info.setSdkSlotClick(Long.parseLong(value));
                    break;
                }
                case "api_s_e": {
                    info.setApiSlotExposure(Long.parseLong(value));
                    break;
                }
                case "api_s_c": {
                    info.setApiSlotClick(Long.parseLong(value));
                    break;
                }
                case "n_l": {
                    info.setNezhaLaunch(Long.parseLong(value));
                    break;
                }
                case "p_ctr": {
                    info.setPreCtr(Double.parseDouble(value));
                    break;
                }
                case "p_cvr": {
                    info.setPreCvr(Double.parseDouble(value));
                    break;
                }
                case "s_ctr": {
                    info.setStatCtr(Double.parseDouble(value));
                    break;
                }
                case "s_cvr": {
                    info.setStatCvr(Double.parseDouble(value));
                    break;
                }
                case "x_f": {
                    info.setAdxFee(Long.parseLong(value));
                    break;
                }
                case "x_c": {
                    info.setAdxClick(Long.parseLong(value));
                    break;
                }
                case "x_e": {
                    info.setAdxExposure(Long.parseLong(value));
                    break;
                }
                case "x_b": {
                    info.setAdxBid(Long.parseLong(value));
                    break;
                }
                case "x_b_s": {
                    info.setAdxBidSuccess(Long.parseLong(value));
                    break;
                }
                case "b_c": {
                    info.setBackendClick(Long.parseLong(value));
                    break;
                }
                case "fa": {
                    info.setFactor(Double.parseDouble(value));
                    break;
                }
                case "l_c_af": {
                    info.setLandpageClickAfee(Long.parseLong(value));
                    break;
                }
                case "b_e_af": {
                    info.setBackendEffectAfee(Long.parseLong(value));
                    break;
                }
                case "x_m_f": {
                    info.setAdxCpmFee(Long.parseLong(value));
                    break;
                }
                case "x_c_f": {
                    info.setAdxCpcFee(Long.parseLong(value));
                    break;
                }
            }
        }
        return info;
    }

    public static Map<String, Long> getBackendAFeeMap(Map<String, String> data) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            for (String key : data.keySet()) {
                if (!key.endsWith(SUFFIX)) continue;
                String value = data.get(key);
                key = key.replace(SUFFIX, "");
                map.put(key, Long.valueOf(value));
            }
        }
        catch (Exception e) {
            log.error("getBackendAFeeMap error", (Throwable)e);
        }
        return map;
    }
}

