/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DruidUtil {
    public static <T> List<T> mergeList(Class<T> clazz, String dimensions, List<List<String>> dataList) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (StringUtils.isBlank((CharSequence)dimensions)) {
            resultList.add(DruidUtil.mergeOne(clazz, dataList));
            return resultList;
        }
        String[] dimArray = StringUtils.split((String)dimensions, (String)",");
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (List<String> list : dataList) {
            if (!CollectionUtils.isNotEmpty(list)) continue;
            DruidUtil.setValue(dimArray, map, list);
        }
        for (Map.Entry entry : map.entrySet()) {
            resultList.add(DruidUtil.merge(clazz, (List)entry.getValue()));
        }
        return resultList;
    }

    private static <T> T mergeOne(Class<T> clazz, List<List<String>> dataList) {
        ArrayList<String> list = new ArrayList<String>();
        for (List<String> arrayList : dataList) {
            if (!CollectionUtils.isNotEmpty(arrayList)) continue;
            list.add(arrayList.get(0));
        }
        return DruidUtil.merge(clazz, list);
    }

    private static <T> T merge(Class<T> clazz, List<String> druidMetricList) {
        JSONObject json = new JSONObject();
        for (String druidMetricValue : druidMetricList) {
            DruidUtil.mergeFields(druidMetricValue, json);
        }
        return (T)json.toJavaObject(clazz);
    }

    private static String getKey(String[] dimArray, JSONObject jsonObject) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String dimension : dimArray) {
            String value = jsonObject.getString(dimension.trim());
            value = StringUtils.isBlank((CharSequence)value) ? "0" : value;
            stringBuilder.append(value).append("-");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static void mergeFields(String druidMetricValue, JSONObject json) {
        JSONObject jsonObject = JSON.parseObject((String)druidMetricValue);
        Set keySet = jsonObject.keySet();
        for (String key : keySet) {
            String value = jsonObject.getString(key);
            DruidUtil.setValue(key, value, json);
        }
    }

    private static void setValue(String[] dimArray, Map<String, List<String>> map, List<String> list) {
        for (String value : list) {
            String key = DruidUtil.getKey(dimArray, JSON.parseObject((String)value));
            if (map.containsKey(key)) {
                map.get(key).add(value);
                continue;
            }
            ArrayList<String> mapValueList = new ArrayList<String>();
            mapValueList.add(value);
            map.put(key, mapValueList);
        }
    }

    private static void setValue(String key, String value, JSONObject json) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (!json.containsKey((Object)key)) {
            json.put(key, (Object)value);
        } else if (!json.getString(key).equalsIgnoreCase(value) && Double.parseDouble(value) != 0.0) {
            json.put(key, (Object)value);
        }
    }
}

