package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf
 * 数据展示格式
 */
public enum DruidShowTypeEnum {

    ALL(1, "", "timeSegment", "直接返回查询时段内的所有数据"),

    HALF_HOUR(2, "TIME_FLOOR(__time, 'PT30M')", "timeSegment","按照半小时分段返回查询时段内的数据"),

    HOUR(3, "TIME_FLOOR(__time,'PT1H')", "timeSegment","按照1小时分段返回查询时段内的数据");



    //数据展示格式对应的编码
    private final Integer code;

    //需要拼接的sql代码段
    private final String sqlSegment;

    //时间字段的别名
    private final String fieldName;

    //解释说明
    private final String desc;

    DruidShowTypeEnum(Integer code, String sqlSegment, String fieldName, String desc) {
        this.code = code;
        this.sqlSegment = sqlSegment;
        this.fieldName = fieldName;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getSqlSegment() {
        return sqlSegment;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getDesc() {
        return desc;
    }}
