package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.DictEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-24
 * 推啊业务-维度对应的属性字段
 */
public enum TuiaDictEnum implements DictEnum {

    //媒体维度表
    APP_NAME(TuiaDimensionEnum.APP_ID.toString(), "app_name", "dim_app_df", "app", "app_id","媒体名称"),
    APP_SOURCE(TuiaDimensionEnum.APP_ID.toString(), "app_source", "dim_app_df", "app", "app_id","媒体来源"),
    APP_LEVEL(TuiaDimensionEnum.APP_ID.toString(), "app_level", "dim_app_df", "app", "app_id","媒体性质 1-在线KA；2-潜力KA‘3-普通媒体"),
    APP_FLOW_CHANNEL_ID(TuiaDimensionEnum.APP_ID.toString(), "app_flow_channel_id", "dim_app_df", "app", "app_id","流量渠道标签id"),
    APP_FLOW_CHANNEL_DESC(TuiaDimensionEnum.APP_ID.toString(), "app_flow_channel_desc", "dim_app_df", "app", "app_id","流量渠道标签描述"),
    TRADE_TYPE_DESC(TuiaDimensionEnum.APP_ID.toString(), "trade_type_desc", "dim_app_df", "app", "app_id","交易方式标签描述"),
    APP_TYPE_NAME(TuiaDimensionEnum.APP_ID.toString(), "app_type_name", "dim_app_df", "app", "app_id","程序化联盟媒体标签名称"),
    MAIN_MEDIA_OPERATION_NAME(TuiaDimensionEnum.APP_ID.toString(), "main_media_operation_name", "dim_app_df", "app", "app_id","媒体主运营"),
    MEDIA_ONE(TuiaDimensionEnum.APP_ID.toString(), "media_one", "dim_app_df", "app", "app_id","媒体运营1"),
    MEIJIE_MANAGER_NAME(TuiaDimensionEnum.APP_ID.toString(), "meijie_manager_name", "dim_app_df", "app", "app_id","媒介"),
    APP_FIRST_TAG_DESC(TuiaDimensionEnum.APP_ID.toString(), "app_first_tag_desc", "dim_app_df", "app", "app_id","一级标签描述"),
    APP_SECOND_TAG_DESC(TuiaDimensionEnum.APP_ID.toString(), "app_second_tag_desc", "dim_app_df", "app", "app_id","二级标签描述"),
    APP_FLOW_TAG_DESC(TuiaDimensionEnum.APP_ID.toString(), "app_flow_tag_desc", "dim_app_df", "app", "app_id","媒体流量标签描述"),
    DEVELOPER_ID(TuiaDimensionEnum.APP_ID.toString(), "developer_id", "dim_app_df", "app", "app_id","账号id"),
    APP_LEVEL_TAG_DESC(TuiaDimensionEnum.APP_ID.toString(), "app_level_tag_desc", "dim_app_df", "app", "app_id","流量分级标签描述"),

    //广告位维度表
    SLOT_NAME(TuiaDimensionEnum.SLOT_ID.toString(), "slot_name", "dim_slot_df", "slot", "slot_id","广告位名称"),
    SLOT_TYPE(TuiaDimensionEnum.SLOT_ID.toString(), "slot_type", "dim_slot_df", "slot", "slot_id","广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙"),
    SLOT_ACCESS_TYPE(TuiaDimensionEnum.SLOT_ID.toString(), "slot_access_type", "dim_slot_df", "slot", "slot_id","接入广告类型 0-互动广告 1-展示广告"),
    SCENE_TYPE(TuiaDimensionEnum.SLOT_ID.toString(), "scene_type", "dim_slot_df", "slot", "slot_id","投放场景，1：插屏，2：banner/横幅，3：信息流，6：浮标，7：应用墙，8：开屏，9：自定义场景，10：原生插屏，11：icon"),
    STRATEGY_ID(TuiaDimensionEnum.SLOT_ID.toString(), "strategy_id", "dim_slot_df", "slot", "slot_id","上报策略 1-多O概率上报 2-单资源概率上报 3-直接上报 4-固定收益上报 5-固定收益-自定义上报"),
    LINK_DOCKING_TAGS(TuiaDimensionEnum.SLOT_ID.toString(), "link_docking_tags", "dim_slot_df", "slot", "slot_id","媒体链接对接方式标签：(api;活跃;防封;短链)"),
    OPEN_PREVENT_CLOSE(TuiaDimensionEnum.SLOT_ID.toString(), "open_prevent_close", "dim_slot_df", "slot", "slot_id","是否开启防封：(是；否)"),

    //活动维度表
    ACTIVITY_NAME(TuiaDimensionEnum.ACTIVITY_ID.toString(), "activity_name", "dim_activity_df", "activity", "activity_id","活动名称"),
    SKIN_ID(TuiaDimensionEnum.ACTIVITY_ID.toString(), "skin_id", "dim_activity_df", "activity", "activity_id","活动皮肤ID"),
    SKIN_NAME(TuiaDimensionEnum.ACTIVITY_ID.toString(), "skin_name", "dim_activity_df", "activity", "activity_id","活动皮肤名称"),
    SKIN_TYPE(TuiaDimensionEnum.ACTIVITY_ID.toString(), "skin_type", "dim_activity_df", "activity", "activity_id","皮肤类型"),
    SKIN_TEMPLATE_TYPE(TuiaDimensionEnum.ACTIVITY_ID.toString(), "template_type", "dim_activity_df", "activity", "activity_id","皮肤模板类型"),
    ACTIVITY_TEMPLATE_NAME(TuiaDimensionEnum.ACTIVITY_ID.toString(), "activity_template_name", "dim_activity_df", "activity", "activity_id","活动皮肤类型"),

    //广告位素材表
    MATERIAL_NAME(TuiaDimensionEnum.SLOT_MATERIAL_ID.toString(), "material_title", "dim_slot_material_df", "material", "material_id","素材名称"),
    MATERIAL_PICTURE_TYPE(TuiaDimensionEnum.SLOT_MATERIAL_ID.toString(), "picture_type", "dim_slot_material_df", "material", "material_id","素材图片类型 0:动图 1:静图 3:视频"),
    MATERIAL_CREATE_TIME(TuiaDimensionEnum.SLOT_MATERIAL_ID.toString(), "material_create_time", "dim_slot_material_df", "material", "material_id","素材创建时间"),

    //广告维度表
    ADVERT_NAME(TuiaDimensionEnum.ADVERT_ID.toString(), "advert_name", "dim_advert_df", "advert", "advert_id","广告名称"),
    ADVERT_TYPE(TuiaDimensionEnum.ADVERT_ID.toString(), "advert_type", "dim_advert_df", "advert", "advert_id","广告类型 1-互动广告、2-展示广告、3-激励广告"),
    ACCOUNT_ID(TuiaDimensionEnum.ADVERT_ID.toString(), "account_id", "dim_advert_df", "advert", "advert_id","广告主id"),
    ACCOUNT_NAME(TuiaDimensionEnum.ADVERT_ID.toString(), "account_name", "dim_advert_df", "advert", "advert_id","广告主名称"),
    AGENT_NAME(TuiaDimensionEnum.ADVERT_ID.toString(), "agent_name", "dim_advert_df", "advert", "advert_id","所属代理商名称，如果本身为代理商则为空"),
    TRADE_TAG_ID(TuiaDimensionEnum.ADVERT_ID.toString(), "trade_tag_id", "dim_advert_df", "advert", "advert_id","综合行业标签编码"),
    NEW_TRADE(TuiaDimensionEnum.ADVERT_ID.toString(), "new_trade", "dim_advert_df", "advert", "advert_id","综合行业名称"),
    RESOURE_TAG_NAME(TuiaDimensionEnum.ADVERT_ID.toString(), "resoure_tag_name", "dim_advert_df", "advert", "advert_id","广告对应资源标签名称"),
    ADVERT_SECOND_TRADE_NAME(TuiaDimensionEnum.ADVERT_ID.toString(), "advert_second_trade_name", "dim_advert_df", "advert", "advert_id","广告二级行业名称"),
    SSO_AE_NAME(TuiaDimensionEnum.ADVERT_ID.toString(), "sso_ae_name", "dim_advert_df", "advert", "advert_id","AE姓名"),
    SELL_NAME(TuiaDimensionEnum.ADVERT_ID.toString(), "sell_name", "dim_advert_df", "advert", "advert_id","销售姓名"),

    //adx推广组维度表
    GROUP_NAME(TuiaDimensionEnum.GROUP_ID.toString(), "group_name", "dim_adx_group_df", "adxGroup", "group_id","推广组名称"),

    //adx资源位维度表
    RESOURCE_NAME(TuiaDimensionEnum.RESOURCE_ID.toString(), "resource_name", "dim_adx_resource_df", "resource", "resource_id","资源位名称"),

    //adx创意维度表
    IDEA_NAME(TuiaDimensionEnum.IDEA_ID.toString(), "idea_name", "dim_adx_idea_df", "idea", "idea_id","创意名称"),
    DSP_SLOT_ID(TuiaDimensionEnum.IDEA_ID.toString(), "dsp_slot_id", "dim_adx_idea_df", "idea", "idea_id","dsp广告位id"),
    DSP_ID(TuiaDimensionEnum.IDEA_ID.toString(), "dsp_id", "dim_adx_idea_df", "idea", "idea_id","dsp平台id"),
    DSP_NAME(TuiaDimensionEnum.IDEA_ID.toString(), "dsp_name", "dim_adx_idea_df", "idea", "idea_id","dsp平台名称"),






    ;


    //关联的维度字段
    private final String dimensionName;

    //mysql表中对应的字段名称
    private final String tableFieldName;

    //维表的名称
    private final String tableName;

    //维表的别名
    private final String aliasName;

    //主键
    private final String primaryKey;

    //属性字段说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaDictEnum(String dimensionName, String tableFieldName, String tableName, String aliasName, String primaryKey, String desc) {
        this.dimensionName = dimensionName;
        this.tableFieldName = tableFieldName;
        this.tableName = tableName;
        this.aliasName = aliasName;
        this.primaryKey = primaryKey;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getDimensionName() {
        return dimensionName;
    }

    public String getTableName() {
        return tableName;
    }

    public String getAliasName() {
        return aliasName;
    }

    public String getPrimaryKey() {
        return primaryKey;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaDictEnum[] values = TuiaDictEnum.values();
        for (TuiaDictEnum value : values) {
            enumList.add(value.toString());
        }
    }

}
