package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.DimensionEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-24
 * 推啊业务-维度字段
 */
public enum TuiaDimensionEnum implements DimensionEnum {

    //天（借用 tableFieldName 字段，用于声明数据展示的格式）
    DAY(HologresShowTypeEnum.DAY.toString(), "timeSegment", "String", 2,"天"),

    //小时（借用 tableFieldName 字段，用于声明数据展示的格式）
    HOUR(HologresShowTypeEnum.HOUR.toString(), "timeSegment", "String", 2,"小时"),

    //只展示小时，不展示日期（借用 tableFieldName 字段，用于声明数据展示的格式）
    ONLY_HOUR(HologresShowTypeEnum.ONLY_HOUR.toString(), "timeSegment", "String", 2,"只展示小时，不展示日期"),

    //半小时（借用 tableFieldName 字段，用于声明数据展示的格式）
    HALF_HOUR(HologresShowTypeEnum.HALF_HOUR.toString(), "timeSegment", "String", 2,"半小时"),

    //10分钟（借用 tableFieldName 字段，用于声明数据展示的格式）
    TEN_MINUTES(HologresShowTypeEnum.TEN_MINUTES.toString(), "timeSegment", "String", 2,"10分钟"),

    //5分钟（借用 tableFieldName 字段，用于声明数据展示的格式）
    FIVE_MINUTES(HologresShowTypeEnum.FIVE_MINUTES.toString(), "timeSegment", "String", 2,"5分钟"),

    //1分钟（借用 tableFieldName 字段，用于声明数据展示的格式）
    ONE_MINUTES(HologresShowTypeEnum.ONE_MINUTES.toString(), "timeSegment", "String", 2,"1分钟"),

    //实验计划id
    ABTEST_PLAN_ID("abtest_plan_id", "abtestPlanId", "int", 1,"实验计划id"),

    //实验分组id
    ABTEST_GROUP_ID("abtest_group_id", "abtestGroupId", "int", 1,"实验分组id"),

    //实验计划和分组
    ABTEST("ab_test", "abtest", "array-string", 1,"字符串数组，每个元素的格式：实验计划id-实验分组id"),

    //媒体id
    APP_ID("app_id", "appId", "int", 1,"媒体id"),

    //广告位id
    SLOT_ID("slot_id", "slotId", "int", 1,"广告位id"),

    //活动id
    ACTIVITY_ID("activity_id", "activityId", "int", 1,"活动id"),

    //广告id
    ADVERT_ID("advert_id", "advertId", "int", 1,"广告id"),

    //广告定向配置id
    ORIENTATION_ID("orientation_id", "orientationId", "int", 1,"广告定向配置id"),

    //资源位类型：1-直投；2-浮标；3-推荐弹层；4-第一次返回拦截；5-谢谢参与推荐弹层；6-下拉推荐位；7-第二次返回拦截；9-第三次返回拦截；10-直投广告；11-adx直投广告
    RESOURCE_TYPE("dsm2_a", "resourceType", "int", 1, "资源位类型：1-直投；2-浮标；3-推荐弹层；4-第一次返回拦截；5-谢谢参与推荐弹层；6-下拉推荐位；7-第二次返回拦截；9-第三次返回拦截；10-直投广告；11-adx直投广告"),

    //活动流量来源类型：1-微信,2-QQ,3-支付宝,4-其他,5-微信小程序,6-支付宝小程序,7-微信快应用
    APP_FLOW_TYPE("app_flow_type", "appFlowType", "int", 1, "活动流量来源类型：1-微信,2-QQ,3-支付宝,4-其他,5-微信小程序,6-支付宝小程序,7-微信快应用"),

    //广告券流量来源类型 1-微信,2-QQ,3-支付宝,4-其他,5-微信小程序,6-支付宝小程序,7-微信快应用
    ADVERT_FLOW_TYPE("app_flow_type_from23", "advertFlowType", "int", 1, "广告券流量来源类型 1-微信,2-QQ,3-支付宝,4-其他,5-微信小程序,6-支付宝小程序,7-微信快应用"),

    //广告位活动投放类型：1-插件工具、2-活动工具、3-直投页、4-展示广告，5-浮标 6-激励等（activityType）
    SLOT_ACTIVITY_TYPE("slot_activity_type", "slotActivityType", "int", 1, "广告位活动投放类型：1-插件工具、2-活动工具、3-直投页、4-展示广告，5-浮标 6-激励等（activityType）"),

    //广告素材id
    MATERIAL_ID("material_id", "materialId", "int", 1,"广告素材id"),

    //券弹层ID
    COUPON_LAYER_ID("coupon_layer_id", "couponLayerId", "int", 1, "券弹层ID"),

    //券弹层类型(0:活动;1:积木)
    COUPON_LAYER_TYPE("coupon_layer_type", "couponLayerType", "int", 1, "券弹层类型(0:活动;1:积木)"),

    //落地页来源 0-广告推广链接；1-AB测试链接；2-新媒体测试链接；3-定向配置链接；4-特殊广告链接；5-DSP平台adx推广链接；6-广告测试素材绑定落地页
    ADVERT_PROMOTE_SOURCE("advert_promote_source", "advertPromoteSource", "int", 1, "落地页来源 0-广告推广链接；1-AB测试链接；2-新媒体测试链接；3-定向配置链接；4-特殊广告链接；5-DSP平台adx推广链接；6-广告测试素材绑定落地页"),

    //操作系统类型 android/ios
    OS_TYPE("os_type", "osType", "String", 1, "操作系统类型 android/ios"),

    //网络运营商类型 1-移动2-联通3-电信4-未知
    ISP("isp", "isp", "int", 1, "网络运营商类型 1-移动2-联通3-电信4-未知"),

    //手机品牌
    BRAND_NAME("brand_name", "brandName", "String", 1, "手机品牌"),

    //发券次序
    LAUNCH_TIMES("launch_times", "launchTimes", "int", 1, "发券次序"),

    //活动曝光来源 0-广告位正常访问；1-弹层关闭后 (参与结果弹层关闭后)；2-落地页返回 (券落地页返回)
    EXPOSURE_SOURCE("exposure_source", "exposureSource", "int", 1, "活动曝光来源 0-广告位正常访问；1-弹层关闭后 (参与结果弹层关闭后)；2-落地页返回 (券落地页返回)"),

    //活动参与次序减1，用于关联全链路数据
    TRACK_JOIN_TIMES("track_join_times", "trackJoinTimes", "int", 1, "活动参与次序减1，用于关联全链路数据"),

    //活动参与前置引导类型 1-积木动效 (积木动效弹层)；2-现金激励 (现金激励奖励弹层)；3-快应用点击组件
    BOOT_TYPE("boot_type", "bootType", "int", 1, "活动参与前置引导类型 1-积木动效 (积木动效弹层)；2-现金激励 (现金激励奖励弹层)；3-快应用点击组件"),

    //活动参与触发类型 0-点击；1-自动参与 (自动玩一次,如大转盘自动开始转)；2-自动出券 (自动调dojoin接口并出券,玩法没有参与动效)
    TRIGGER_TYPE("trigger_type", "triggerType", "int", 1, "活动参与触发类型 0-点击；1-自动参与 (自动玩一次,如大转盘自动开始转)；2-自动出券 (自动调dojoin接口并出券,玩法没有参与动效)"),

    //广告位素材id
    SLOT_MATERIAL_ID("slot_material_id", "slotMaterialId", "int", 1,"广告位素材id"),

    //是否回流数据（不为空表示回流数据）
    AUTO_FLOW_BACK("auto_flow_back", "autoFlowBack", "String", 1,"是否回流数据（不为空表示回流数据）"),

    //ADX推广组id
    GROUP_ID("group_id", "groupId", "int", 1,"ADX推广组id"),

    //ADX资源位id
    RESOURCE_ID("resource_id", "resourceId", "int", 1,"ADX资源位id"),

    //ADX创意id
    IDEA_ID("idea_id", "ideaId", "int", 1,"ADX创意id"),

    //ADX创意素材Id
    IDEA_MATERIAL_ID("idea_material_id", "ideaMaterialId", "int", 1,"ADX创意素材Id"),

    //外部联盟媒体ID
    EXT_APP_ID("ext_app_id", "extAppId", "String", 1,"外部联盟媒体ID"),

    //外部联盟广告位ID
    EXT_SLOT_ID("ext_slot_id", "extSlotId", "String", 1,"外部联盟广告位ID"),

    //媒体包名
    PACKAGE_NAME("package_name", "packageName", "String", 1,"媒体包名"),

    //dsp任务ID
    DSP_TASK_ID("dsp_task_id", "dspTaskId", "String", 1,"dsp任务ID"),

    //业务类型(1:adx业务)
    BUSINESS_TYPE("business_type", "businessType", "int", 1,"业务类型(1:adx业务)"),

    //城市编码(直辖市:2位编码 其它城市:4位编码)
    CITY_ID("city_id", "cityId", "int", 1,"城市编码(直辖市:2位编码 其它城市:4位编码)"),

    //城市名称
    CITY_NAME("city_name", "cityName", "String", 1,"城市名称"),

    //省份编码(2位)
    PROVINCE_ID("province_id", "provinceId", "int", 1,"省份编码(2位)"),

    //省份名称
    PROVINCE_NAME("province_name", "provinceName", "String", 1,"省份名称"),

    //广告目标转化类型
    TARGET_EFFECT_TYPE("target_effect_type", "targetEffectType", "int", 1,"广告目标转化类型"),

    //计费类型：CPA、CPC、ECMP
    CHARGE_TYPE("charge_type", "chargeType", "String", 1,"计费类型：CPA、CPC、ECMP"),

    //投放模式：0-人工包；1-稳定投放；2-抢量优先（中）；3-抢量优先（高）；4-人工定向；5-成本优先
    PUT_TARGET_TYPE("put_target_type", "putTargetType", "int", 1,"投放模式：0-人工包；1-稳定投放；2-抢量优先（中）；3-抢量优先（高）；4-人工定向；5-成本优先"),

    //深度优化类型：0-落地页转化；1-安装；2-启动；3-注册；4-激活；5-登录；6-付费；7-进件；8-完件；9-签收；10-留存
    DEPTH_TARGET_EFFECT_TYPE("depth_target_effect_type", "depthTargetEffectType", "int", 1,"深度优化类型：0-落地页转化；1-安装；2-启动；3-注册；4-激活；5-登录；6-付费；7-进件；8-完件；9-签收；10-留存"),

    //媒体开户账号id
    OPEN_ACCOUNT_ID("open_account_id", "openAccountId", "String", 1,"媒体开户账号id"),

    //外部广告id
    EXT_ADVERT_ID("ext_advert_id", "extAdvertId", "String", 1,"外部广告id"),

    //外部广告组id
    EXT_ADVERT_GROUP_ID("ext_advert_group_id", "extAdvertGroupId", "String", 1,"外部广告组id"),

    //外部创意id
    EXT_IDEA_ID("ext_idea_id", "extIdeaId", "String", 1,"外部创意id"),

    //投放场景：1-点券直接上报；2-转化概率多o；3-点券概率多o；4-转化直接上报
    PUT_SCENE("put_scene", "putScene", "int", 1,"投放场景：1-点券直接上报；2-转化概率多o；3-点券概率多o；4-转化直接上报"),

    //流量是否绑券 (0:否 1:是)
    CUSTOMIZE_COUPON("customize_coupon", "customizeCoupon", "int", 1,"流量是否绑券 (0:否 1:是)"),








    ;


    //hologres 中表定义的字段名称
    private final String tableFieldName;

    //结果数据对应的别名
    private final String resultFieldName;

    //hologres 表中的字段类型(String, int, bigint等等)
    private final String fieldType;

    //维度类型 （1:普通维度 2:时间维度）
    private final Integer dimType;

    //维度字段解释说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaDimensionEnum(String tableFieldName, String resultFieldName, String fieldType, Integer dimType, String desc) {
        this.tableFieldName = tableFieldName;
        this.resultFieldName = resultFieldName;
        this.fieldType = fieldType;
        this.dimType = dimType;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getFieldType() {
        return fieldType;
    }

    public Integer getDimType() {
        return dimType;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaDimensionEnum[] values = TuiaDimensionEnum.values();
        for (TuiaDimensionEnum value : values) {
            enumList.add(value.toString());
        }
    }
}
