package cn.com.duiba.bigdata.common.biz.utils;

import cn.com.duiba.bigdata.common.biz.domain.CalculateMetricDomain;
import cn.com.duiba.bigdata.common.biz.dto.DuibaLiveDto;
import cn.com.duiba.bigdata.common.biz.dto.TuiaResultDto;
import cn.com.duiba.bigdata.common.biz.enums.*;
import cn.com.duiba.bigdata.common.biz.interfaces.*;

import java.util.List;
import java.util.Map;

/**
 * @author xugf 2023-11-28
 * 业务枚举工具类
 */
public class BusinessEnumUtil {

    /**
     * 获取维度枚举
     *
     * @param businessType 业务线类型
     * @param dimension    维度名称
     * @return DimensionEnum
     */
    public static DimensionEnum getDimensionEnum(int businessType, String dimension) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDimensionEnum.valueOf(dimension);
        }

        return null;
    }

    /**
     * 获取维度枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getDimensionEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDimensionEnum.enumList;
        }

        return null;
    }

    /**
     * 获取基础指标枚举
     *
     * @param businessType 业务线类型
     * @param metric       基础指标名称
     * @return MetricEnum
     */
    public static MetricEnum getMetricEnum(int businessType, String metric) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaMetricEnum.valueOf(metric);
        }

        return null;
    }

    /**
     * 获取基础指标枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getMetricEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaMetricEnum.enumList;
        }

        return null;
    }

    /**
     * 获取计算类指标枚举
     *
     * @param businessType 业务线类型
     * @param metric       计算类指标名称
     * @return CalculateMetricEnum
     */
    public static CalculateMetricEnum getCalculateMetricEnum(int businessType, String metric) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCalculateMetricEnum.valueOf(metric);
        }

        return null;
    }

    /**
     * 获取计算类指标枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getCalculateMetricEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCalculateMetricEnum.enumList;
        }

        return null;
    }

    /**
     * 获取计算类指标返回结果字段
     * @param businessType 业务线类型
     * @return map
     */
    public static Map<String, CalculateMetricDomain> getCalculateMetricResultFieldMap(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCalculateMetricEnum.resultFieldMap;
        }

        return null;
    }

    /**
     * 获取组合类指标枚举
     *
     * @param businessType 业务线类型
     * @param metric       计算类指标名称
     * @return CombineMetricEnum
     */
    public static CombineMetricEnum getCombineMetricEnum(int businessType, String metric) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCombineMetricEnum.valueOf(metric);
        }

        return null;
    }

    /**
     * 获取组合类指标枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getCombineMetricEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaCombineMetricEnum.enumList;
        }

        return null;
    }

    /**
     * 获取字典属性枚举
     *
     * @param businessType 业务线类型
     * @param name 维度对应的属性名称
     * @return CombineMetricEnum
     */
    public static DictEnum getDictEnum(int businessType, String name) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDictEnum.valueOf(name);
        }

        return null;
    }

    /**
     * 获取字典属性枚举列表
     *
     * @param businessType 业务线类型
     * @return list
     */
    public static List<String> getDictEnumList(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaDictEnum.enumList;
        }

        return null;
    }

    /**
     * 获取业务线对应的结果DTO
     * @param businessType 业务线类型
     * @return Class
     */
    public static Class getResultDto(int businessType) {
        if (businessType == BusinessEnum.TUIA.getBusinessType()) {
            return TuiaResultDto.class;
        } else if (businessType == BusinessEnum.DUIBA_LIVE.getBusinessType()) {
            return DuibaLiveDto.class;
        }

        return null;
    }

    public static void main(String[] args) {
        Class<TuiaResultDto> resultClass = getResultDto(1);
        String className = resultClass.getName();
        System.out.println(className);

        resultClass = getResultDto(3);
        className = resultClass.getName();
        System.out.println(className);
    }


}
